
(function(a) {
    a.event.special.textchange = {
        setup: function() {
            a(this).data("lastValue", this.contentEditable === "true" ? a(this).html() : a(this).val());
            a(this).bind("keyup.textchange", a.event.special.textchange.handler);
            a(this).bind("cut.textchange paste.textchange input.textchange", a.event.special.textchange.delayedHandler)
        },
        teardown: function() {
            a(this).unbind(".textchange")
        },
        handler: function() {
            a.event.special.textchange.triggerIfChanged(a(this))
        },
        delayedHandler: function() {
            var b = a(this);
            setTimeout(function() {
                a.event.special.textchange.triggerIfChanged(b)
            }, 25)
        },
        triggerIfChanged: function(b) {
            var c = b[0].contentEditable === "true" ? b.html() : b.val();
            if (c !== b.data("lastValue")) {
                b.trigger("textchange", b.data("lastValue"));
                b.data("lastValue", c)
            }
        }
    };
    a.event.special.hastext = {
        setup: function() {
            a(this).bind("textchange", a.event.special.hastext.handler)
        },
        teardown: function() {
            a(this).unbind("textchange", a.event.special.hastext.handler)
        },
        handler: function(b, c) {
            c === "" && c !== a(this).val() && a(this).trigger("hastext")
        }
    };
    a.event.special.notext = {
        setup: function() {
            a(this).bind("textchange", a.event.special.notext.handler)
        },
        teardown: function() {
            a(this).unbind("textchange", a.event.special.notext.handler)
        },
        handler: function(b, c) {
            a(this).val() === "" && a(this).val() !== c && a(this).trigger("notext")
        }
    }
})(jQuery);

$.fn.textValidation = function(options) {
    var field = $(this);
    field.option = {
        regex: /^.*$/,
        canBeNull: false,
        nullMsg: 'Can not be null',
        errorMsg: 'Error',
        customFn: null,
        checkFn: null
    }
	
    field.check = function(result) { //result = isValid
       	var isValid = result[0];
        var msg = result[1];
        
        if (field.is(":disabled")) {
            isValid = true;
        }
        
        if (isValid) {
            field.removeClass("text_invalid");
            field.unbind("mouseover").unbind("mouseout");
        	field.parents("body:last").find(".invalid_msg, .iframe_help_div").remove();
        } else {
            field.addClass("text_invalid").bind("mouseover", function() {
                var left = 0;
                var top = 0;
                
                var curLeft = 0, curTop = 0;
                
                if ($.browser.msie) {
                    var offsetParent = field.get(0);
                    while (offsetParent != null && offsetParent != document.body) {
                        left += offsetParent.offsetLeft;
                        top += offsetParent.offsetTop;
                        offsetParent = offsetParent.offsetParent;
                    }
                    top += 25;
                } else {
                    left = parseInt(field.offset().left);
                    top = parseInt(field.offset().top + 25);
                }
                
            	field.parents("body:last").find(".invalid_msg, .iframe_help_div").remove();
                field.parents("body:last").append("<div class='invalid_msg circle_corner' style='left:" + left + "px;top:" + top + "px;z-index:99999;'>" + msg + "</div>");
            	var msg_div = field.parents("body:last").find(".invalid_msg");
				field.parents("body:last").find(".invalid_msg").after("<iframe class='iframe_help_div' style='width: " + $(msg_div).outerWidth(true) + "px; height: " + $(msg_div).outerHeight(true) + "px; left:" + left + "px;top:" + top + "px;z-index:99998; border:0px;'></iframe>");
			}).bind("mouseout", function() {
            	field.parents("body:last").find(".invalid_msg, .iframe_help_div").remove();
            });
        }
        
        if (field.option.customFn != null) 
            field.option.customFn(isValid, field);
    }
    
    if (options != undefined) {
        field.option = $.extend(field.option, options);
        if (field.option.checkFn == null) {
            field.option.checkFn = function(value) {
				var isValid = true;
		        var msg = field.option.errorMsg;
		        if (value == "") {
		            if (field.option.canBeNull) {
		                isValid = true;
		            } else {
		                isValid = false;
		                msg = field.option.nullMsg;
		            }
		        } else {
                	var reg = new RegExp(field.option.regex);
		            if (!reg.test(value)) {
		                isValid = false;
		            }
		        }
                return [isValid, msg];
            }
        }
    }
    
    field.bind('textchange', function() {
        field.check(field.option.checkFn(field.val()));
    });
    
    field.bind('change', function() {
        field.trigger("textchange");
    });
    
    return field;
}