var REQ = { OQCCONFIG:1, STARTCHARGING:2, STOPCHARGING:3 };

var gTotalEnergy = 0;

var lang = getLang(window.location.search.substring(1));
loadI18nBundles(lang);
$(document).ready(function() {
    setI18n();
	initEvent();
	
    $("body").show();
});

function setI18n() {
	var mb_labels = [
        $.i18n.prop("test_total_energy"),
	];

	$("#test_div .w_form_header div").text($.i18n.prop("tab_test"));

	$(".iconbutn:eq(0)").find("span").text($.i18n.prop("test_oqcconfig"));
	$(".iconbutn:eq(1)").find("span").text($.i18n.prop("test_start_charging"));
	$(".iconbutn:eq(2)").find("span").text($.i18n.prop("test_stop_charging"));

	for(var i = 0; i < mb_labels.length; i++) {
		$("#test_div label").eq(i).text(mb_labels[i] + ":");
	}
}

function initEvent(){
	$(".iconbutn:eq(0)").click(function(){ request("oqcconfig"); });
	$(".iconbutn:eq(1)").click(function(){ request("start_charging"); });
	$(".iconbutn:eq(2)").click(function(){ request("stop_charging"); });
}
/*
function showConfirmMsg(cmd, msg){
	lightBox({
		title: $.i18n.prop("message_message"),
		width: 300,
		escable: false,
		closable: false,
		buttons: [{
			text: $.i18n.prop("butn_yes"),
			handler: function() {
				top.closeLightBox();
				setTimeout(function(){
					request(cmd);
				}, 500);
			}
		},{
			text: $.i18n.prop("butn_no"),
			handler: function() {
				top.closeLightBox();
			}
		}]
	}).showMsg(msg);
}
*/
function request(action) {
	//top.$("#loading").showDialog(); // Only work when show test.html in the frame
	
    $.ajax({
        url: "../cgi-bin/Test.cgi",
        type: "POST",
        cache: false,
        dataType: "json",
        timeout: 60000,
        data: selectjson(action),
        success: function(data, textStatus, XMLHttpRequest) {
            //top.$("#loading").hideDialog(); // Only work when show test.html in the frame
            if (XMLHttpRequest.status == 200) { //OK
                selectfunc(action, data);
            } else {
                error(XMLHttpRequest, textStatus);
            }
        },
        error: function(XMLHttpRequest, textStatus) {
			//if(action != "upload_failed" && action != "wlupload_failed"){
				top.$("#loading").hideDialog();
				ajaxErrorFunc(XMLHttpRequest, textStatus);
			//}
        }
    });
};

/**
 * Data to be sent to the server. It is converted to a query 
 * string. 
 *  
 * @param {String} action
 */
function selectjson(action) {
    var req_json = new jsonCreator();
    req_json.addstring("req", "testreq");
    
    switch (action) {
        case "oqcconfig":
            req_json.addindex("action", REQ.OQCCONFIG);
            break;
        case "start_charging":
            req_json.addindex("action", REQ.STARTCHARGING);
            break;
        case "stop_charging":
            req_json.addindex("action", REQ.STOPCHARGING);
            break;
        	
        default:
            break;
    }
    
    return req_json.get();
}

/**
 * A function to be called if the request succeeds. 
 *  
 * @param action [in] 
 * @param data   [in] data returned from the server, formatted 
 *               according to the dataType parameter
 */
function selectfunc(action, data) {
    var statuscode = parseInt(data.code);
    
    if (statuscode == 1000) { //RESULTCODE_OK
        switch (action) {
	        case "oqcconfig":
	        	//showMessage($.i18n.prop("message_message"), $.i18n.prop("oqcconfig_success"));
	            break;
            case "start_charging":
	        	//showMessage($.i18n.prop("message_message"), $.i18n.prop("start_charging_success"));
                gTotalEnergy = parseInt(data.active_energy);
	        	$("#total_energy").val("");
                break;
            case "stop_charging":
	        	//showMessage($.i18n.prop("message_message"), $.i18n.prop("stop_charging_success"));
                gTotalEnergy = parseInt(data.active_energy) - gTotalEnergy;
                $("#total_energy").val(gTotalEnergy);
                break;
	        
            default:
                break;
        }
    } else {
		//if(action != "upload_failed" && action != "wlupload_failed"){
			showErrorMsg(statuscode);
		//}
    }
}