var REQ = {QUERY:1, UPLOAD:2, FAILED: 3, QUERYFILES: 4, CLEARFILES: 5, RESETALLUSER: 6};
var ITEM = {CLIENT_CERT: 1, CLIENT_KEY: 2, ROOT_CERT: 3};
var lang = getLang(window.location.search.substring(1));
loadI18nBundles(lang);
$(document).ready(function() {
    setI18n();
	initEvent();
	setCss();
	request("queryfiles");
	
	//For Lolox
	$('#upload_div').hide();
	//
	
    $("body").show();
});

function setI18n(){
	var upload_labels = [$.i18n.prop("security_client_certificate"), $.i18n.prop("security_client_privatekey"), $.i18n.prop("security_root_certificate")];
	
    $("#upload_div .w_form_header div").text($.i18n.prop("tab_upload_files"));
    $("#changepwd_div .w_form_header div").text($.i18n.prop("tab_change_pwd"));
	
    $("label[for=clientcer_form]").text(upload_labels[0] + ":");
    $("label[for=clientkey_form]").text(upload_labels[1] + ":");
    $("label[for=rootcer_form]").text(upload_labels[2] + ":");

	$("#select_user option[value='1']").text("admin");
	$("#select_user option[value='2']").text("guest");
	
    $("#changepwd_div label").eq(0).text($.i18n.prop("security_pwd_user") + ":");
    $("#changepwd_div label").eq(1).text($.i18n.prop("security_old_pwd") + ":");
    $("#changepwd_div label").eq(2).text($.i18n.prop("security_new_pwd") + ":");
	
	$(".iconbutn:has(.uploadicon)").find("span").text($.i18n.prop("butn_upload"));
	$(".iconbutn:has(.applyicon)").find("span").text($.i18n.prop("butn_apply"));	
	$(".iconbutn:has(.clearbtn)").find("span").text($.i18n.prop("butn_clearcert"));
	$(".iconbutn:has(.resetalluserbtn)").find("span").text($.i18n.prop("butn_resetallpwd"));

}

function initEvent(){
	$(".iconbutn:has(.applyicon):eq(0)").click(function(){
		request("changepwd");
	});
	
	$(".iconbutn:has(.uploadicon):eq(0)").click(function(){
		startUpload("cc");
	});
	
	$(".iconbutn:has(.uploadicon):eq(1)").click(function(){
		startUpload("ck");
	});
	
	$(".iconbutn:has(.uploadicon):eq(2)").click(function(){
		startUpload("rc");
	});
	
	$(".iconbutn:has(.clearbtn)").click(function(){
		request("clearfiles");
	});
	
	$(".iconbutn:has(.resetalluserbtn)").click(function(){
		showConfirmMsg();
	});	

	
	$("input[about='nochange']").disable();	
}

function setCss(){
	$("input[type=password]").attr("size", 40);
}

function startUpload(item){
	var id = "";
	var command = "";
	switch(item){
		case "cc":
			id = "clientcer_form";
			command = "upcc_finished";
			break;
		case "ck":
			id = "clientkey_form";
			command = "upck_finished";
			break;
        case "rc":
			id = "rootcer_form";
			command = "uprc_finished";
			break;
		default:
			break;
	}
	if($("#" + id).find(".filename").val() == ""){
		showMessage($.i18n.prop("message_error"), $.i18n.prop("message_upgrade_nofile"));
	}else{
		top.$("#loading").showDialog();
		$("#" + id).ajaxSubmit({
			url: "../cgi-bin/Upload.cgi",
			type: "POST",
			cache: false,
			dataType: "text",
			success: function(data, textStatus, XMLHttpRequest){
				var data = null;
				if(isJSON(XMLHttpRequest.responseText)){
					data = JSON.parse(XMLHttpRequest.responseText);
				}
				if(data != null && data.code == 1000){
					request(command);
				}else {
					this.error(textStatus, XMLHttpRequest);
				}
			},
			error: function(XMLHttpRequest, textStatus) {
				var data = null;
				if(isJSON(XMLHttpRequest.responseText)){
					data = JSON.parse(XMLHttpRequest.responseText);
				}
				if(data != null && data.code == 1000){
					request(command);
				}else {
					request("upload_failed");
					top.$("#loading").hideDialog();
					switch(textStatus){
						case "timeout":
							showMessage($.i18n.prop("message_error"), $.i18n.prop("message_timeout"));
							break;
							
						default:
							showMessage($.i18n.prop("message_error"), $.i18n.prop("message_upload_failed"));
							break;
					}
				}
			}
		});
	}
}

function showConfirmMsg(){
	lightBox({
		title: $.i18n.prop("message_message"),
		width: 300,
		escable: false,
		closable: false,
		buttons: [{
			text: $.i18n.prop("butn_yes"),
			handler: function() {
				top.closeLightBox();
				setTimeout(function(){
					request("resetalluser");
				}, 500);
			}
		},{
			text: $.i18n.prop("butn_no"),
			handler: function() {
				top.closeLightBox();
			}
		}]
	}).showMsg($.i18n.prop("security_resetalluser_confirm"));
}
/**
 *
 * @param {String} action
 */
function request(action, arg) {
	if(action != "upload_failed"){
		top.$("#loading").showDialog();
	}
    $.ajax({
        url: "../cgi-bin/Security.cgi",
        type: "POST",
        cache: false,
        dataType: "json",
        timeout: 60000,
        data: selectjson(action, arg),
        success: function(data, textStatus, XMLHttpRequest) {
			top.$("#loading").hideDialog();
            if (XMLHttpRequest.status == 200) {
                selectfunc(action, data);
            } else {
                error(XMLHttpRequest, textStatus);
            }
        },
        error: function(XMLHttpRequest, textStatus) {
			top.$("#loading").hideDialog();
			ajaxErrorFunc(XMLHttpRequest, textStatus);
		}
    });
};

/**
 *
 * @param {String} action
 */
function selectjson(action, arg) { //選擇要傳送的req JSON
    var req_json = new jsonCreator();
    req_json.addstring("req", "securityreq");
    
    switch (action) {
        case "changepwd":
            req_json.addindex("action", REQ.QUERY);
        	req_json.addindex("userid", $("#select_user").val());
            req_json.addstring("old_pwd", $("#oldpassword").val());
            req_json.addstring("new_pwd", $("#newpassword").val());
            break;
            
        case "upcc_finished":
        case "upck_finished":
        case "uprc_finished":
            req_json.addindex("action", REQ.UPLOAD);
			
			if(action == "upcc_finished"){
				req_json.addindex("item", ITEM.CLIENT_CERT);
			}else if(action == "upck_finished"){
				req_json.addindex("item", ITEM.CLIENT_KEY);
			}else if(action == "uprc_finished"){
				req_json.addindex("item", ITEM.ROOT_CERT);
			}
			break;
            
        case "upload_failed":
            req_json.addindex("action", REQ.FAILED);
			break;
			
		case "queryfiles":
			req_json.addindex("action", REQ.QUERYFILES);
			break;
			
		case "clearfiles":
			req_json.addindex("action", REQ.CLEARFILES);
			break;
			
		case "resetalluser":
			req_json.addindex("action", REQ.RESETALLUSER);
			break;
            
        default:
            break;
    }
    
    return req_json.get();
}

function selectfunc(action, data) {
    var statuscode = parseInt(data.code);
    
    if (statuscode == 1000) {
        switch (action) {
			case "changepwd":
				showMessage($.i18n.prop("message_message"), $.i18n.prop("security_chgpwd"));
				break;
				
			case "upcc_finished":
			case "upck_finished":
			case "uprc_finished":
				request("queryfiles");
				showMessage($.i18n.prop("message_message"), $.i18n.prop("security_upload_success"));
				break;
				
			case "upload_failed":
	            break;
	        
	        case "queryfiles":
				$("#clientcer_file").val(data.clientcert);
				$("#clientkey_file").val(data.clientcacert);
				$("#rootcer_file").val(data.servercertkey);
	        	break;
	        	
	        case "clearfiles":
	        	request("queryfiles");
	        	showMessage($.i18n.prop("message_message"), $.i18n.prop("security_clearcertok"));
	        	break;
	        	
	        case "resetalluser":
				showMessage($.i18n.prop("message_message"), $.i18n.prop("security_resetalluserok"));
				break;
	            
            default:
                break;
        }
    } else {
		if(action != "upload_failed"){
			showErrorMsg(statuscode);
		}
    }
}
