var REQ = {REBOOT:1, FINISH:2, FAILED:3, SHOWWLIST:4, SHOWCACHE:5, CLEARCACHE:6, RESETMFG:7, SHOWCPORFILE:8, CLEARCPORFILE:9, WLISTFINISH:10, WLISTFAILED:11, CACHEFINISH:12, CACHEFAILED:13, CLEARWLIST:14, SETTINGFAILED:15};
var REQ_ACTION = {QUERY:1, SET:2, SSID_SCAN:3, IMPORT:4};
var ITEM = {WARNING:1, GENERAL:2, SERVICE:3, OCPP:4, IP:5, REMOTE_CONTROL:6};

var lang = getLang(window.location.search.substring(1));
loadI18nBundles(lang);
$(document).ready(function() 
{
    setI18n();
	initEvent();

    $("body").show();
});

function setI18n() {
	
	$("#command_div .w_form_header div").text($.i18n.prop("tab_command"));
	$("#chargingprofile_div .w_form_header div").text($.i18n.prop("tab_chargingprofile"));
	$("#whitelist_div .w_form_header div").text($.i18n.prop("tab_whitelist"));
	$("#upgrade_div .w_form_header div").text($.i18n.prop("tab_firmupgrade"));	
	$("label[for=upload_file]").text($.i18n.prop("maintain_upgrade_choose") + ":");
	
	$("#import_export_div .w_form_header div").text($.i18n.prop("tab_export_import"));
	
	$(".iconbutn:eq(0)").find("span").text($.i18n.prop("maintain_reboot"));
	$(".iconbutn:eq(1)").find("span").text($.i18n.prop("maintain_resetmfg"));
	$(".iconbutn:eq(2)").find("span").text($.i18n.prop("maintain_showchargingprofile"));
	$(".iconbutn:eq(3)").find("span").text($.i18n.prop("maintain_clearchargingprofile"));
	$(".iconbutn:eq(4)").find("span").text($.i18n.prop("maintain_showwhitelist"));	
	$(".iconbutn:eq(5)").find("span").text($.i18n.prop("maintain_clearwhitelist"));
	$(".iconbutn:eq(6)").find("span").text($.i18n.prop("maintain_upload_list"));
	$(".iconbutn:eq(7)").find("span").text($.i18n.prop("maintain_showauthcache"));
	$(".iconbutn:eq(8)").find("span").text($.i18n.prop("maintain_clearauthcache"));
	$(".iconbutn:eq(9)").find("span").text($.i18n.prop("maintain_upload_cache"));
	$(".iconbutn:eq(10)").find("span").text($.i18n.prop("butn_upload"));
	$(".iconbutn:eq(11)").find("span").text($.i18n.prop("butn_export"));
	$(".iconbutn:eq(12)").find("span").text($.i18n.prop("butn_import"));
	
	$(".second_msg").append($.i18n.prop("message_reboot") + "<span class='second_counter'></span> " + $.i18n.prop("maintain_sec") + ".");
}

function doUploadfile(filepath, theform, finished, failed){
		if($(filepath).val() == ""){
			showMessage($.i18n.prop("message_error"), $.i18n.prop("message_upgrade_nofile"));
		}else{
			var cgi;
			if (finished == "upload_setting_finished")
				cgi = "../cgi-bin/Upload.cgi?upload_setting_finished";
			else
				cgi = "../cgi-bin/Upload.cgi";
			
			top.$("#loading").showDialog();
			$(theform).ajaxSubmit({
				url: cgi,
				type: "POST",
		        cache: false,
				dataType: "text",
				success: function(data, textStatus, XMLHttpRequest){
					var data = null;
					if(isJSON(XMLHttpRequest.responseText)){
						data = JSON.parse(XMLHttpRequest.responseText);
					}
					if(data != null && data.code == 1000){
						if (finished == "upload_setting_finished") {
							$.ajaxSetup({async: false});	//stop synchronized
							request("warning_set", data);
							request("general_set", data);
							request("control_set", data);
							request("service_set", data);
							request("ocpp_set", data);
							request("ip_set", data);		//start synchronized
							$.ajaxSetup({async: true});
							showConfirmMsg("reboot", $.i18n.prop("import_reboot_prompt"));
						} else {
							request(finished);
						}
					}else {
						this.error(textStatus, XMLHttpRequest);
					}
				},
				error: function(XMLHttpRequest, textStatus) {
					var data = null;
					if(isJSON(XMLHttpRequest.responseText)){
						data = JSON.parse(XMLHttpRequest.responseText);
					}
					if(data != null && data.code == 1000){
						request(finished);
					}else {
						request(failed);
						top.$("#loading").hideDialog();
						if (failed == "upload_setting_failed") {
							showMessage($.i18n.prop("message_error"), $.i18n.prop("import_format_error"));
						} else {
							switch(textStatus){
								case "timeout":
									showMessage($.i18n.prop("message_error"), $.i18n.prop("message_timeout"));
									break;
									
								default:
									showMessage($.i18n.prop("message_error"), $.i18n.prop("message_upload_failed"));
									break;
							}
						}
					}
				}
			});
		}
}

function initEvent(){
	$(".iconbutn:eq(0)").click(function(){ showConfirmMsg("reboot", $.i18n.prop("maintain_reboot_confirm")); });
	$(".iconbutn:eq(1)").click(function(){ showConfirmMsg("resetmfg", $.i18n.prop("maintain_resetmfg_confirm")); });
	$(".iconbutn:eq(2)").click(function(){ request("showchargingprofile"); });
	$(".iconbutn:eq(3)").click(function(){ showConfirmMsg("clearchargingprofile", $.i18n.prop("maintain_clearprofile_confirm")); });
	$(".iconbutn:eq(4)").click(function(){ request("showwhitelist"); });
	$(".iconbutn:eq(5)").click(function(){ showConfirmMsg("clearwlist", $.i18n.prop("maintain_clearwlist_confirm")); });
	$(".iconbutn:eq(6)").click(function(){ doUploadfile("#upload_whitelist", "#whitelist_form", "wlupload_finished", "wlupload_failed"); });
	$(".iconbutn:eq(7)").click(function(){ request("showcache"); });
	$(".iconbutn:eq(8)").click(function(){ showConfirmMsg("clearcache", $.i18n.prop("maintain_clearcache_confirm")); });
	$(".iconbutn:eq(9)").click(function(){ doUploadfile("#upload_cachelist", "#cachelist_form", "cacheupload_finished", "cacheupload_failed"); });
	$(".iconbutn:eq(10)").click(function(){ doUploadfile("#upload_file", "#upgrade_form", "upload_finished", "upload_failed"); });
	$(".iconbutn:eq(11)").click(function(){ request("query"); });
	$(".iconbutn:eq(12)").click(function(){ doUploadfile("#import_file", "#import_form", "upload_setting_finished", "upload_setting_failed"); });
}

function showConfirmMsg(cmd, msg){
	lightBox({
		title: $.i18n.prop("message_message"),
		width: 300,
		escable: false,
		closable: false,
		buttons: [{
			text: $.i18n.prop("butn_yes"),
			handler: function() {
				top.closeLightBox();
				setTimeout(function(){
					request(cmd);
				}, 500);
			}
		},{
			text: $.i18n.prop("butn_no"),
			handler: function() {
				top.closeLightBox();
			}
		}]
	}).showMsg(msg);
}

function showRebootMsg()
{
	top.location.href = "../";
}

function displayWindow(title)
{
	$("#show_window").window('setTitle', $.i18n.prop(title));
	$('#show_window').window('open');
	$('#show_window').window('center');
	$('#show_window').window('refresh', "../~tmpDisplay.htm");
}

function selectCGI(action) {
	switch (action) {
		case "query":
		case "warning_set":
		case "general_set":
		case "service_set":
		case "control_set":
		case "ocpp_set":
		case "ip_set":
			return "../cgi-bin/Config.cgi";
			break;
		
		default:
			return "../cgi-bin/Maintain.cgi";
			break;
	}
}

function request(action, setting = "")
{
	if(action != "upload_failed" && action != "wlupload_failed" && action != "cacheupload_failed" && action != "upload_setting_failed")
	{
		top.$("#loading").showDialog();
	}
    $.ajax({
        url: selectCGI(action),
        type: "POST",
        cache: false,
        dataType: "json",
        timeout: 180000,
        data: selectjson(action, setting),
        success: function(data, textStatus, XMLHttpRequest) {
            top.$("#loading").hideDialog();
            if (XMLHttpRequest.status == 200) {
                selectfunc(action, data);
            } else {
                error(XMLHttpRequest, textStatus);
            }
        },
        error: function(XMLHttpRequest, textStatus) {
			if(action != "upload_failed" && action != "wlupload_failed" && action != "cacheupload_failed" && action != "upload_setting_failed"){
				top.$("#loading").hideDialog();
				ajaxErrorFunc(XMLHttpRequest, textStatus);
			}
        }
    });
}

/**
 *
 * @param {String} action
 */
function selectjson(action, setting = "") { //選擇要傳送的req JSON
    var req_json = new jsonCreator();
    
	switch (action) {
		case "query":
		case "warning_set":
		case "general_set":
		case "service_set":
		case "control_set":
		case "ocpp_set":
		case "ip_set":
			req_json.addstring("req", "configreq");
			break;
			
		default:
			req_json.addstring("req", "maintainreq");
			break;
	}
    
    switch (action) {
		case "warning_set":
			req_json.addindex("action", REQ_ACTION.IMPORT);
            req_json.addindex("item", ITEM.WARNING);
			
			//Monitoring Criteria
			req_json.addindex("temperature_low", setting.temperature_low);
			req_json.addindex("temperature_high", setting.temperature_high);
			req_json.addindex("voltage_low", setting.voltage_low);
			req_json.addindex("voltage_high", setting.voltage_high);
			break;
			
		case "general_set":
            req_json.addindex("action", REQ_ACTION.IMPORT);
            req_json.addindex("item", ITEM.GENERAL);

            //Power Settings
			req_json.addstring("maxamp_fwsetting", setting.maxamp_fwsetting);
			req_json.addindex("clpickup_delay", setting.clpickup_delay);
            //Scenario
			req_json.addstring("plugandcharge_identifier", setting.plugandcharge_identifier);
			req_json.addindex("reservation_supported", setting.reservation_supported);
			req_json.addindex("resume_charging", setting.resume_charging);
			req_json.addindex("rfid_enable", setting.rfid_enable);
			req_json.addindex("ventilation_area", setting.ventilation_area);
			req_json.addindex("skip_heartbeat", setting.skip_heartbeat);
			req_json.addindex("restart_time", setting.restart_time);
			req_json.addindex("restart_counter", setting.restart_counter);						
            break;
		
		case "control_set":
            req_json.addindex("action", REQ_ACTION.IMPORT);
            req_json.addindex("item", ITEM.REMOTE_CONTROL);
			
        	req_json.addindex("remote_control_type", setting.remote_control_type);
            break;
		
		case "service_set":
            req_json.addindex("action", REQ_ACTION.IMPORT);
            req_json.addindex("item", ITEM.SERVICE);
            
			//req_json.addstring("cp_identity", setting.cp_identity);
			req_json.addstring("server_url", setting.server_url);
			req_json.addstring("server_userid", setting.server_userid);
			req_json.addstring("server_password", setting.server_password);
			req_json.addstring("ftp_userid", setting.ftp_userid);
			req_json.addstring("ftp_password", setting.ftp_password);
			req_json.addindex("msg_translayer", setting.msg_translayer);
			req_json.addindex("bn_interval", setting.bn_interval);
			req_json.addindex("bn_retries", setting.bn_retries);
			req_json.addindex("pdu_timeout", setting.pdu_timeout);
			req_json.addindex("df_interval", setting.df_interval);
			req_json.addindex("df_retries", setting.df_retries);
			req_json.addindex("ud_interval", setting.ud_interval);
			req_json.addindex("ud_retries", setting.ud_retries);
			req_json.addstring("unit_price", setting.unit_price);
			req_json.addstring("idle_fee", setting.idle_fee);
			req_json.addstring("idle_fee_charging", setting.idle_fee_charging);	
			req_json.addstring("initiation_fee", setting.initiation_fee);				
			req_json.addstring("custom_display_costandprice", setting.custom_display_costandprice);									
			req_json.addstring("notification_after_softreset", setting.notification_after_softreset);
			break;
		
		case "ocpp_set":
            req_json.addindex("action", REQ_ACTION.IMPORT);
            req_json.addindex("item", ITEM.OCPP);
            
			req_json.addindex("ocpp16_9101", setting.ocpp16_9101);
			req_json.addindex("ocpp16_9102", setting.ocpp16_9102);
			req_json.addindex("ocpp16_9103", setting.ocpp16_9103);
			req_json.addindex("ocpp16_9104", setting.ocpp16_9104);
			req_json.addindex("ocpp16_9105", setting.ocpp16_9105);
			req_json.addindex("ocpp16_9106", setting.ocpp16_9106);
			req_json.addindex("ocpp16_9108", setting.ocpp16_9108);
			req_json.addindex("ocpp16_9109", setting.ocpp16_9109);
			req_json.addindex("ocpp16_9110", setting.ocpp16_9110);
			req_json.addindex("ocpp16_9111", setting.ocpp16_9111);
			req_json.addindex("ocpp16_9112", setting.ocpp16_9112);
			req_json.addstring("ocpp16_9113", setting.ocpp16_9113);
			req_json.addstring("ocpp16_9115", setting.ocpp16_9115);
			req_json.addindex("ocpp16_9117", setting.ocpp16_9117);
			req_json.addindex("ocpp16_9118", setting.ocpp16_9118);
			req_json.addindex("ocpp16_9120", setting.ocpp16_9120);
			req_json.addindex("ocpp16_9121", toNumber(setting.ocpp16_9121));
			req_json.addindex("ocpp16_9123", setting.ocpp16_9123);
			req_json.addindex("ocpp16_9124", setting.ocpp16_9124);
			req_json.addstring("ocpp16_9125", setting.ocpp16_9125);
			req_json.addstring("ocpp16_9127", setting.ocpp16_9127);
			req_json.addindex("ocpp16_9131", setting.ocpp16_9131);
			req_json.addindex("ocpp16_9132", setting.ocpp16_9132);
			req_json.addindex("ocpp16_9133", setting.ocpp16_9133);
			req_json.addindex("ocpp16_9134", setting.ocpp16_9134);
			req_json.addindex("ocpp16_9201", setting.ocpp16_9201);
            break;
		
		case "ip_set":
            req_json.addindex("action", REQ_ACTION.IMPORT);
            req_json.addindex("item", ITEM.IP);
			
			//Networking Settings
			req_json.addindex("dev_mode", setting.dev_mode);
			req_json.addstring("master_lanip", setting.master_lanip);
			req_json.addindex("master_lanport", setting.master_lanport);
			req_json.addindex("maxdev_number", setting.maxdev_number);
            req_json.addstring("gateway_serial", setting.gateway_serial);
            req_json.addindex("use_external_gw", setting.use_external_gw);
            req_json.addindex("hide_ap_ssid", setting.hide_ap_ssid);
			req_json.addindex("connectivity", setting.connectivity);
			req_json.addindex("led_brightness", setting.led_brightness);
            //Ethernet Settings
			req_json.addindex("link_mode", setting.link_mode);
			req_json.addstring("ip", setting.ip);
			req_json.addstring("mask", setting.mask);
			req_json.addstring("default_gateway", setting.default_gateway);
			req_json.addstring("primary_dns", setting.primary_dns);
			req_json.addstring("secondary_dns", setting.secondary_dns);
            //WiFi Settings
			req_json.addstring("wifi_ssid", setting.wifi_ssid);
			req_json.addstring("wifi_security", setting.wifi_security);
			req_json.addstring("wifi_password", setting.wifi_password);
			req_json.addstring("wifi_bssid", setting.wifi_bssid);
			req_json.addstring("wifi_station_only", setting.wifi_station_only);
            //mobile settings
			req_json.addstring("cellular_apn", setting.cellular_apn);
            req_json.addstring("cellular_apntype", setting.cellular_apntype);
			req_json.addstring("cellular_apnuser", setting.cellular_apnuser);
			req_json.addstring("cellular_apnpwd", setting.cellular_apnpwd);
			req_json.addstring("cellular_dialnum", setting.cellular_dialnum);
			req_json.addstring("cellular_pincode", setting.cellular_pincode);
			req_json.addstring("cellular_pridns", setting.cellular_pridns);
			req_json.addstring("cellular_secdns", setting.cellular_secdns);
			req_json.addstring("cellular_port_forwarding", setting.cellular_port_forwarding);
			req_json.addstring("cellular_port_range", setting.cellular_port_range);
			req_json.addstring("cellular_timeout_receive", setting.cellular_timeout_receive);
			req_json.addstring("cellular_reconnect", setting.cellular_reconnect);
			//llm settings
			req_json.addindex("llm_mode", setting.llm_mode);
			req_json.addindex("llm_policy", setting.llm_policy);
			req_json.addstring("llm_groupid", setting.llm_groupid);
			req_json.addindex("llm_chargers", setting.llm_chargers);
			req_json.addstring("llm_maxamp_grid", setting.llm_maxamp_grid);
			req_json.addstring("llm_fallback", setting.llm_fallback);
			break;
		
		case "query":
			req_json.addindex("action", REQ_ACTION.QUERY);
			break;
		
        case "reboot":
            req_json.addindex("action", REQ.REBOOT);
            break;
			
        case "upload_finished":
            req_json.addindex("action", REQ.FINISH);
            break;
			
	    case "upload_failed":
            req_json.addindex("action", REQ.FAILED);
            break;
            
        case "showwhitelist":
        	req_json.addindex("action", REQ.SHOWWLIST);
        	break;
        	
        case "showcache":
        	req_json.addindex("action", REQ.SHOWCACHE);
        	break;
        	
        case "clearcache":
        	req_json.addindex("action", REQ.CLEARCACHE);
        	break;
        	
        case "clearwlist":
        	req_json.addindex("action", REQ.CLEARWLIST);
        	break;
        	
        case "resetmfg":
            req_json.addindex("action", REQ.RESETMFG);
            break;
        	
        case "showchargingprofile":
            req_json.addindex("action", REQ.SHOWCPORFILE);
            break;
        	
        case "clearchargingprofile":
            req_json.addindex("action", REQ.CLEARCPORFILE);
            break;
			
        case "wlupload_finished":
            req_json.addindex("action", REQ.WLISTFINISH);
            break;
			
	    case "wlupload_failed":
            req_json.addindex("action", REQ.WLISTFAILED);
            break;
			
        case "cacheupload_finished":
            req_json.addindex("action", REQ.CACHEFINISH);
            break;
			
	    case "cacheupload_failed":
            req_json.addindex("action", REQ.CACHEFAILED);
            break;
        
		case "upload_setting_failed":
			req_json.addindex("action", REQ.SETTINGFAILED);
            break;
		
        default:
            break;
    }
    
	//console.log(req_json.get());
	
    return req_json.get();
}

function selectfunc(action, data) {
    var statuscode = parseInt(data.code);
    
    if (statuscode == 1000) {		
        switch (action) {
			case "query":
				delete data["code"];
				delete data["cp_vender"];
				delete data["cp_model"];
				delete data["cp_serialnum"];
				delete data["cp_type"];
				delete data["hard_version"];
				delete data["firm_version"];
				delete data["meter_type"];
				delete data["reader_type"];
				delete data["dsmr_type"];
				delete data["production_date"];
				delete data["connector_num"];
				delete data["connector_type"];
				delete data["connector_maxamp"];
                delete data["cp_identity"];
				download(JSON.stringify(data), "Setting.conf", "text/plain");
				break;
			
	        case "reboot":
				showRebootMsg();
	            break;
	            
			case "upload_finished":
				lightBox({
						title: $.i18n.prop("message_message"),
						width: 300,
						escable: false,
						closable: false,
						buttons: [{
							text: $.i18n.prop("butn_ok"),
							handler: function() {
								top.closeLightBox();
								top.location.href = "../";
							}
						}]
					}).showMsg($.i18n.prop("maintain_upgrade_success"));
	            break;
	            
	       	case "wlupload_finished":
	       		showMessage($.i18n.prop("message_message"), $.i18n.prop("maintain_wlupgrade_success"));
				break;
	            
	       	case "cacheupload_finished":
	       		showMessage($.i18n.prop("message_message"), $.i18n.prop("maintain_cacheupgrade_success"));
				break;
			
	        case "upload_failed":
	        case "wlupload_failed":
	        case "cacheupload_failed":
			case "upload_setting_failed":
	            break;
	        
	        case "showwhitelist":
	        case "showcache":
	        	displayWindow("tab_whitelist");
	        	break;
	            
	        case "clearcache":
	        	showMessage($.i18n.prop("message_message"), $.i18n.prop("maintain_clearcache_success"));
	        	break;
	            
	        case "clearwlist":
	        	showMessage($.i18n.prop("message_message"), $.i18n.prop("maintain_clearwlist_success"));
	        	break;
	        	
	        case "resetmfg":
				lightBox({
						title: $.i18n.prop("message_message"),
						width: 300,
						escable: false,
						closable: false,
						buttons: [{
							text: $.i18n.prop("butn_ok"),
							handler: function() {
								top.closeLightBox();
								top.location.href = "../";
							}
						}]
					}).showMsg($.i18n.prop("maintain_resetmfg_ok"));
	            break;	            
	        case "showchargingprofile":
	        	displayWindow("tab_chargingprofile");
	        	break;
	        
            default:
                break;
        }
    } 
    else 
    {
		if(action != "upload_failed" && action != "wlupload_failed" && action != "cacheupload_failed" && action != "upload_setting_failed")
			showErrorMsg(statuscode);
    }
}
