var langmap = {
    "en-US": "English"
};
loadI18nBundles("en-US");
$(document).ready(function() {
	$("img.logo").attr("src", "img/logo.png");
    $("#producttitle").text("Intelligent Charger Gen3");
	document.title = "LITEON IC3 Web Portal";
    $("#username,#password").val("");
    initEvent();
	createLangsCombo();
    $("body").show();
	resetFormPosition();
});

function loadI18nBundles(lang){
    $.i18n.properties({
        name: 'Application',
        path: 'i18n/',
        language: lang,
		mode: 'map'
    });
}

function initEvent() {
	$(window).resize(resetFormPosition);
    $("#loginbutn").click(function() {
        request("login");
    });
    
    document.onkeydown = keydown;
}

function keydown(e) {
    var currKey = 0, e = e || event;
    currKey = e.keyCode || e.which || e.charCode;//支持IE、FF
    if (!$("#loginbutn").is(":disabled") && currKey == 13) {
        $("#loginbutn").focus();
    }
}

function removeDuplicate(arrayName) {
    var newArray = new Array();
    label: for (var i = 0; i < arrayName.length; i++) {
        for (var j = 0; j < newArray.length; j++) {
            if (newArray[j] == arrayName[i]) 
                continue label;
        }
        newArray[newArray.length] = arrayName[i];
    }
    return newArray;
}

function createLangsCombo(langs) {
    $("#language").empty();
    if (!langs) {
        langs = ["en-US"];
    } else if ($.inArray("en-US", langs) == -1) {
        langs.push("en-US");
    }
    
	langs = removeDuplicate(langs);
    langs.sort();
    
    for (var i = 0; i < langs.length; i++) {
        top.document.getElementById("language").options.add(new Option(langmap[langs[i]], langs[i]));
    }
    $("#language").val("en-US").enable();
}

function resetFormPosition(){
	var $ad = $(".logintable");
	var _height = $ad.height();
    var _diffY = 100;
	var _top = ($(window).height() - _height - _diffY) /2;
	if(_top < 0) _top = 0; 
	$ad.css("top", _top).css("position", "relative");
	//$(".top_space").css("height", $(document).height() / 5);
}

/**
 *
 * @param {String} action
 */
function getUrl(action) {
    switch (action) {
        case "login":
            return "cgi-bin/Login.cgi";
            
        /*case "get_langs":
            return "cgi-bin/Language.cgi";*/
            
        default:
            break;
    }
}

/**
 *
 * @param {String} action
 */
function request(action) {
    $.ajax({
        url: getUrl(action),
        type: "POST",
        cache: false,
        dataType: "json",
        timeout: 30000,
        data: selectjson(action),
        success: function(data, textStatus, XMLHttpRequest) {
            if (XMLHttpRequest.status == 200) {
                selectfunc(action, data);
            } else {
                error(XMLHttpRequest, textStatus);
            }
        },
        error: function(XMLHttpRequest, textStatus) {
            switch (textStatus) {
                case "timeout":
                    $("#msg").text($.i18n.prop("message_timeout"));
                    break;
                    
				case "parsererror":
                    $("#msg").text($.i18n.prop("message_parseerror"));
					break;
				
				case "error":	
                default:
					var msg = $.i18n.prop("message_http_code");
					var status = XMLHttpRequest.status;
					if(status == undefined){
						msg = $.i18n.prop("message_error");
						status = textStatus;
					}
                    $("#msg").text(msg + ": " + status);
                    break;
            }
        }
    });
};

/**
 *
 * @param {String} action
 */
function selectjson(action) { //選擇要傳送的req JSON
    var req_json = new jsonCreator();
    
    switch (action) {
        case "login":
            req_json.addstring("req", "loginreq");
            req_json.addstring("id", document.loginform.username.value);
            req_json.addstring("password", document.loginform.password.value);
            break;
            
        /*case "get_langs":
            req_json.addstring("req", "langreq");
            break;*/
            
        default:
            break;
    }
    
    return req_json.get();
}

function selectfunc(action, data) {
    var statuscode = parseInt(data.code);
    
    if (statuscode == 1000) {
        switch (action) {
            case "login":
                window.location.href = "html/device.html?lang=" + document.loginform.language.value;
                break;
                
            /*case "get_langs":
                createLangsCombo(data.langs);
                break;*/
                
            default:
                break;
        }
    } else {
        $("#msg").text($.i18n.prop("result_code_" + statuscode));
    }
}
