var REQ = { SHMINFO_CB:1, SHMINFO_NB:2, SHMINFO_NET:3, SHOW_DEV_STATE:4 };

var lang = getLang(window.location.search.substring(1));
loadI18nBundles(lang);
$(document).ready(function() 
{
    setI18n();
	initEvent();
	
    $("body").show();
});

function setI18n() {
	$("#evse_div .w_form_header div").text($.i18n.prop("tab_evse"));

	$(".iconbutn:eq(0)").find("span").text($.i18n.prop("evse_shminfo_cb"));
	$(".iconbutn:eq(1)").find("span").text($.i18n.prop("evse_shminfo_nb"));
	$(".iconbutn:eq(2)").find("span").text($.i18n.prop("evse_shminfo_net"));
	$(".iconbutn:eq(3)").find("span").text($.i18n.prop("evse_shminfo_devstate"));
}

function initEvent()
{
	$(".iconbutn:eq(0)").click(function(){ request("shminfo_cb"); });
	$(".iconbutn:eq(1)").click(function(){ request("shminfo_nb"); });
	$(".iconbutn:eq(2)").click(function(){ request("shminfo_net"); });
	$(".iconbutn:eq(3)").click(function(){ request("show_device_state"); });
}

function request(action) 
{
	top.$("#loading").showDialog();
	
    $.ajax({
        url: "../cgi-bin/Evse.cgi",
        type: "POST",
        cache: false,
        dataType: "json",
        timeout: 180000,
        data: selectjson(action),
        success: function(data, textStatus, XMLHttpRequest) {
            top.$("#loading").hideDialog();
            if (XMLHttpRequest.status == 200) {
                selectfunc(action, data);
            } else {
                error(XMLHttpRequest, textStatus);
            }
        },
        error: function(XMLHttpRequest, textStatus) {
			//if(action != "upload_failed" && action != "wlupload_failed"){
				top.$("#loading").hideDialog();
				ajaxErrorFunc(XMLHttpRequest, textStatus);
			//}
        }
    });
};

/**
 *
 * @param {String} action
 */
function selectjson(action) { //選擇要傳送的req JSON
    var req_json = new jsonCreator();
    req_json.addstring("req", "evsereq");
    
    switch (action) {
        case "shminfo_cb":
            req_json.addindex("action", REQ.SHMINFO_CB);
            break;

        case "shminfo_nb":
            req_json.addindex("action", REQ.SHMINFO_NB);
            break;

        case "shminfo_net":
            req_json.addindex("action", REQ.SHMINFO_NET);
            break;

        case "show_device_state":
            req_json.addindex("action", REQ.SHOW_DEV_STATE);
            break;

        default:
            break;
    }
    
    return req_json.get();
}


function selectfunc(action, data) {
    var statuscode = parseInt(data.code);
    
    if (statuscode == 1000) {
        switch (action) {
	        case "shminfo_cb":
	        case "shminfo_nb":
	        case "shminfo_net":
	        case "show_device_state":
	        	$("#show_window").window('setTitle', $.i18n.prop("tab_evse"));
	        	$('#show_window').window('open');
	        	$('#show_window').window('center');
	        	$('#show_window').window('refresh', "../~tmpDisplay.htm");
	            break;
	        
            default:
                break;
        }
    } else {
			showErrorMsg(statuscode);
    }
}