var privilege = 1;
var lang = getLang(window.location.search.substring(1));
loadI18nBundles(lang);
$(document).ready(function(){
	$("img.logo").attr("src", "../img/logo_s.png");
	$("#mainContent").attr("src", "../html/config.html?lang=" + lang);
	$("#loading").mydialog();
	setI18n();
	initEvent();
	request("about");
});

function setI18n() {
	$(".product_title").text("Intelligent Charger Gen3");
	document.title = "LITEON IC3 Web Portal";
	$("#logoutbutn .l-btn-text").text($.i18n.prop("action_logout"));
	
	$("#menu_config").text($.i18n.prop("menu_configuration"));
	$("#menu_maintain").text($.i18n.prop("menu_maintenance"));
	$("#menu_evse").text($.i18n.prop("menu_evse"));
	$("#menu_llm").text($.i18n.prop("menu_llm"));
	$("#menu_security").text($.i18n.prop("menu_security"));
	$("#menu_test").text($.i18n.prop("menu_test"));
}

function initEvent(){
	$("#logoutbutn").click(function(){
		request("logout");
	});
	$("#menu_config").click(function(){
		changeSrc("../html/config.html?lang=" + lang);
		setMenuCss(this.id);
	});
	$("#menu_maintain").click(function(){
		changeSrc("../html/maintain.html?lang=" + lang);
		setMenuCss(this.id);
	});
	$("#menu_evse").click(function(){
		changeSrc("../html/evse.html?lang=" + lang);
		setMenuCss(this.id);
	});
	$("#menu_llm").click(function(){
		changeSrc("../html/llm.html?lang=" + lang);
		setMenuCss(this.id);
	});
	$("#menu_test").click(function(){
		changeSrc("../html/test.html?lang=" + lang);
		setMenuCss(this.id);
	});
}

function changeSrc(src){
    $("#mainContent").attr("src", src);
}

function setMenuCss(item){
	$(".menu_item").removeClass("menu_selected");
	$("#" + item).addClass("menu_selected");
}

function getUrl(action){
	 switch (action) {
        case "logout":
            return "../cgi-bin/Logout.cgi";
			
        case "about":
            return "../cgi-bin/About.cgi";
            
        default:
            break;
    }
	
}

function checkPrivilege(){
	if(isTopPrivilege()){
		$("#menu_security").show();
		//$("#menu_test").show();
		$("#menu_security").click(function(){
			changeSrc("../html/security.html?lang=" + lang);
			setMenuCss(this.id);
		});
		$("#menu_test").click(function(){
			changeSrc("../html/test.html?lang=" + lang);
			setMenuCss(this.id);
		});
	}else{
		$("#menu_security").hide();
		$("#menu_test").hide();
	}
}

/**
 * 
 * @param {String} action
 */
function request(action, arg){
	$("#loading").showDialog();
    $.ajax({
        url: getUrl(action),
        type: "POST",
        cache: false,
        dataType: "json",
        timeout: 30000,
        data: selectjson(action, arg),
        success: function(data, textStatus, XMLHttpRequest){
			$("#loading").hideDialog();
			if(XMLHttpRequest.status == 200){
            	selectfunc(action, data, arg);
			}else{
				error(XMLHttpRequest, textStatus);
			}
        },
        error: function(XMLHttpRequest, textStatus){
			$("#loading").hideDialog();
			ajaxErrorFunc(XMLHttpRequest, textStatus);
        }
    });
};

/**
 * 
 * @param {String} action
 */
function selectjson(action, arg){ //選擇要傳送的req JSON
    var req_json = new jsonCreator();
    
    switch (action) {
        case "logout":
			req_json.addstring("req", "logoutreq");
            break;
			
        case "about":
			req_json.addstring("req", "aboutreq");
            break;
			
        default:
            break;
    }
    
    return req_json.get();
}

function selectfunc(action, data, arg){
    var statuscode = parseInt(data.code);
    
    if (statuscode == 1000) {
        switch (action) {
	        case "logout":
				location.href = "../";
	            break;
				
	        case "about":
				privilege = data.privilege;
	            break;
	           
            default:
                break;
        }
    } else {
		showErrorMsg(statuscode);
    }
	checkPrivilege();
}
