var REQ_ACTION = {QUERY:1, SET:2, SSID_SCAN:3};
var ITEM = {WARNING:1, GENERAL:2, SERVICE:3, OCPP:4, IP:5, REMOTE_CONTROL:6};
var CONNECTIVITY = {NONE:0, AUTO:1, ETHERNET:2, WIFI:3, CELLULAR:4};
var CELLULAR_PDP_TYPE = {IP:0, IPV4V6:1};
var MODE = {DHCP:1, STATIC:2};
var DEVICEMODE = {DIRECT:1, GATEWAY:2, CLIENT:3};
var WIFISECURITY = {NONE:0, WEP:1, WPAPSK:2, WPA2PSK:3, WPAPSKWPA2PSK:4, AUTO:5};
var WIFI_STATION_ONLY = {OFF:0, ON:1};
var LLMMODE = {DISABLE:0, ENABLE:1};
var REMOTECONTROL = {ALL:1, APP:2, OCPP:3};
var TYPE = {IC:0, SC:1, SCC:2, SCP:3};


var ip_regex = /^([1-9]|[1-9]\d|1\d{1,2}|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d{1,2}|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d{1,2}|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d{1,2}|2[0-4]\d|25[0-5])$/;
var lang = getLang(window.location.search.substring(1));


/******************************************************************************************
 * The system should popup a reboot prompt message if the following settings are changed: *
 *     Server URL, Server UserId, Server Password, Operation Mode, Unit Number            *
 ******************************************************************************************/
var g_chargepointid;
var g_server_url;
var g_server_userid;
var g_server_password;
var g_dev_mode;
var g_use_external_gw;
var g_remote_control_type;
var g_LLMEnable;
var g_LLMPolicy;
var g_is_reboot = 0;    //0:FALSE, 1:TRUE
var g_reboot_statuscode = 4501;
var g_model_type = "IC";


function checkModelType(type)
{
	if (type == TYPE.IC)
		g_model_type = "IC"
	else if (type == TYPE.SC)
		g_model_type = "SC"
	else if (type == TYPE.SCC)
		g_model_type = "SCC"
	else if (type == TYPE.SCP)
		g_model_type = "SCP"
}

loadI18nBundles(lang);
$(document).ready(function() {
    setI18n();
    //setCss();
    initEvent();
    
    $("#latitude").hide();
    $("#latitude_text").hide();
    $("#longitude").hide();
    $("#longitude_text").hide();

	request("query");
    $("body").show();
});

function setCss(){
	$("input[type=text]").attr("size", 60);
	$("input[type=text]").attr("maxlength", 256);
}

function setI18n() {
	var fs_labels = [
        //Basic Information
        $.i18n.prop("config_cp_vender"),
        $.i18n.prop("config_cp_model"),
        $.i18n.prop("config_cp_serialnum"),
        $.i18n.prop("config_hard_version"),
        $.i18n.prop("config_firm_version"),
        $.i18n.prop("config_meter_type"),
        $.i18n.prop("config_reader_type"),
        $.i18n.prop("config_dsmr_type"),
        $.i18n.prop("config_production_date"),
        //Charging Connector
        $.i18n.prop("config_connector_num"),
        $.i18n.prop("config_connector_type"),
        $.i18n.prop("config_connector_maxamp"),
	];
	
	var cs_labels = [
        //Monitoring Criteria
        $.i18n.prop("config_temperature_low"),
        $.i18n.prop("config_temperature_high"),
        $.i18n.prop("config_voltage_low"),
        $.i18n.prop("config_voltage_high"),
        //Power Settings
    	$.i18n.prop("config_output_powertype"),
    	$.i18n.prop("config_powerphase_connected"),
    	$.i18n.prop("config_maxamp_hwsetting"),
    	$.i18n.prop("config_maxamp_fwsetting"),
    	$.i18n.prop("config_pwm_amp"),
    	$.i18n.prop("config_real_amp"),
    	$.i18n.prop("config_clpickup_delay"),
        //Scenario
    	$.i18n.prop("config_plugandcharge_identifier"),
    	$.i18n.prop("config_reservation_supported"),
    	$.i18n.prop("config_resume_charging"),
    	$.i18n.prop("config_rfid_enable"),
    	$.i18n.prop("config_ventilation_area"),
    	$.i18n.prop("config_skip_heartbeat"),
		$.i18n.prop("config_restart_time"),	
		$.i18n.prop("config_restart_counter"),			
        //GPS Information
        $.i18n.prop("config_latitude"),
        $.i18n.prop("config_longitude"),
        $.i18n.prop("config_lastboot")
	];	
	
	var ocpp_labels = [
		$.i18n.prop("config_remote_control_type"),
    	$.i18n.prop("config_cp_identity"),
    	$.i18n.prop("config_protocol_name"),
    	$.i18n.prop("config_server_url"),
    	$.i18n.prop("config_server_userid"),
    	$.i18n.prop("config_server_password"),
    	$.i18n.prop("config_ftp_userid"),
    	$.i18n.prop("config_ftp_password"),
    	$.i18n.prop("config_msg_translayer"),
    	$.i18n.prop("config_bn_interval"),
    	$.i18n.prop("config_bn_retries"),
    	$.i18n.prop("config_pdu_timeout"),
    	$.i18n.prop("config_df_interval"),
    	$.i18n.prop("config_df_retries"),
    	$.i18n.prop("config_ud_interval"),
		$.i18n.prop("config_ud_retries"),
		$.i18n.prop("config_unit_price"),
		$.i18n.prop("config_idle_fee"),
		$.i18n.prop("config_idle_fee_charging"),	
		$.i18n.prop("config_initiation_fee"),			
		$.i18n.prop("config_custom_display_costandprice"),				
		$.i18n.prop("config_notification_after_softreset"),				
    	$.i18n.prop("config_ocpp16_9101"),
    	$.i18n.prop("config_ocpp16_9102"),
    	$.i18n.prop("config_ocpp16_9103"),
    	$.i18n.prop("config_ocpp16_9104"),
    	$.i18n.prop("config_ocpp16_9105"),
    	$.i18n.prop("config_ocpp16_9106"),
    	$.i18n.prop("config_ocpp16_9107"),
    	$.i18n.prop("config_ocpp16_9108"),
    	$.i18n.prop("config_ocpp16_9109"),
    	$.i18n.prop("config_ocpp16_9110"),
    	$.i18n.prop("config_ocpp16_9111"),
    	$.i18n.prop("config_ocpp16_9112"),
    	$.i18n.prop("config_ocpp16_9113"),
    	$.i18n.prop("config_ocpp16_9114"),
    	$.i18n.prop("config_ocpp16_9115"),
    	$.i18n.prop("config_ocpp16_9116"),
    	$.i18n.prop("config_ocpp16_9117"),
    	$.i18n.prop("config_ocpp16_9118"),
    	$.i18n.prop("config_ocpp16_9119"),
    	$.i18n.prop("config_ocpp16_9120"),
    	$.i18n.prop("config_ocpp16_9121"),
    	$.i18n.prop("config_ocpp16_9122"),
    	$.i18n.prop("config_ocpp16_9123"),
    	$.i18n.prop("config_ocpp16_9124"),
    	$.i18n.prop("config_ocpp16_9125"),
    	$.i18n.prop("config_ocpp16_9126"),
    	$.i18n.prop("config_ocpp16_9127"),
    	$.i18n.prop("config_ocpp16_9128"),
    	$.i18n.prop("config_ocpp16_9129"),
    	$.i18n.prop("config_ocpp16_9130"),
    	$.i18n.prop("config_ocpp16_9131"),
    	$.i18n.prop("config_ocpp16_9132"),
    	$.i18n.prop("config_ocpp16_9133"),
    	$.i18n.prop("config_ocpp16_9134"),
    	$.i18n.prop("config_ocpp16_9201"),
    	$.i18n.prop("config_ocpp16_9202"),
    	$.i18n.prop("config_ocpp16_9203"),
    	$.i18n.prop("config_ocpp16_9301"),
    	$.i18n.prop("config_ocpp16_9401"),
    	$.i18n.prop("config_ocpp16_9402"),
    	$.i18n.prop("config_ocpp16_9403"),
    	$.i18n.prop("config_ocpp16_9404"),
    	$.i18n.prop("config_ocpp16_9405")
	];	
	
	var ips_labels = [
        //Networking Settings
    	$.i18n.prop("config_dev_mode"),
    	$.i18n.prop("config_master_lanip"),
    	$.i18n.prop("config_master_lanport"),
    	$.i18n.prop("config_maxdev_number"),
    	$.i18n.prop("config_master_sn"),
    	$.i18n.prop("config_use_external_gw"),
    	$.i18n.prop("config_hide_ap_ssid"),
		$.i18n.prop("config_connectivity"),
		$.i18n.prop("config_led_brightness"),
        //Active Device Settings
    	$.i18n.prop("config_active_device"),
        $.i18n.prop("config_active_ipaddr"),
        $.i18n.prop("config_active_netmask"),
        $.i18n.prop("config_active_gateway"),
        $.i18n.prop("config_active_pridns"),
        $.i18n.prop("config_active_secdns"),
        //Ethernet Settings
        $.i18n.prop("config_link_mode"),
        $.i18n.prop("config_ip"),
        $.i18n.prop("config_mask"),
        $.i18n.prop("config_default_gateway"),
        $.i18n.prop("config_primary_dns"),
        $.i18n.prop("config_secondary_dns"),
    	$.i18n.prop("config_eth_macaddr"),
        //Wi-Fi Settings
    	$.i18n.prop("config_wifi_ssid"),
    	$.i18n.prop("config_wifi_security"),
    	$.i18n.prop("config_wifi_password"),
    	$.i18n.prop("config_wifi_bssid"),
    	$.i18n.prop("config_wifi_macaddr"),
    	$.i18n.prop("config_wifi_strength"),
    	$.i18n.prop("config_wifi_station_only"),
        //Cellular Settings
    	$.i18n.prop("config_mnc"),
    	$.i18n.prop("config_iccid"),
    	$.i18n.prop("config_imsi"),
    	$.i18n.prop("config_imei"),
    	$.i18n.prop("config_meid"),
    	$.i18n.prop("config_cellular_apn"),
    	$.i18n.prop("config_cellular_apntype"),
    	$.i18n.prop("config_cellular_apnuser"),
    	$.i18n.prop("config_cellular_apnpwd"),
    	$.i18n.prop("config_cellular_dialnum"),
    	$.i18n.prop("config_cellular_pincode"),
    	$.i18n.prop("config_cellular_pridns"),
    	$.i18n.prop("config_cellular_secdns"),
    	$.i18n.prop("config_cellular_strength"),
    	$.i18n.prop("config_cellular_wan_ipaddr"),
    	$.i18n.prop("config_cellular_port_forwarding"),
    	$.i18n.prop("config_cellular_port_range"),
    	$.i18n.prop("config_cellular_timeout_receive"),
        $.i18n.prop("config_cellular_reconnect"),
        //LLM
    	$.i18n.prop("config_llm_mode"),
    	$.i18n.prop("config_llm_policy"),
    	$.i18n.prop("config_llm_groupid"),
    	$.i18n.prop("config_llm_chargers"),
    	$.i18n.prop("config_llm_maxamp_grid"),
        $.i18n.prop("config_llm_fallback")
	];
	
	//tabs
	$(".tabs-title:eq(0)").text($.i18n.prop("tab_factory_set"));
	$(".tabs-title:eq(1)").text($.i18n.prop("tab_commission_set"));
	$(".tabs-title:eq(2)").text($.i18n.prop("tab_ocpp_set"));
	$(".tabs-title:eq(3)").text($.i18n.prop("tab_ip_set"));
	
	
	//Factory Settings
	$(".group_basic_information").text($.i18n.prop("group_basic_information"));
    $(".group_charging_connector").text($.i18n.prop("group_charging_connector"));

	for(var i = 0; i < fs_labels.length; i++){
		$("#tab_fs label").eq(i).text(fs_labels[i] + ":");
	}
	
	//Station Settings
    $(".group_warning_settings").text($.i18n.prop("group_warning_settings"));
    $(".group_general_settings").text($.i18n.prop("group_general_settings"));
    $(".group_gps_information").text($.i18n.prop("group_gps_information"));

	for(var i = 0; i < cs_labels.length; i++) {
		$("#tab_cs label").eq(i).text(cs_labels[i] + ":");
	}

	// Select and Combobox
	var strMeasurandListSample=
		$.i18n.prop("config_curr_import")+","+
		$.i18n.prop("config_curr_offered")+","+
		$.i18n.prop("config_eng_act_import_register")+","+
		$.i18n.prop("config_power_act_import")+","+
		$.i18n.prop("config_power_offered")+","+
		$.i18n.prop("config_temperature")+","+
		$.i18n.prop("config_voltage");
	var strMeasurandListSampleClock=
		$.i18n.prop("config_curr_import")+","+
		$.i18n.prop("config_curr_offered")+","+
		$.i18n.prop("config_eng_act_import_register")+","+
		$.i18n.prop("config_eng_act_import_interval")+","+
		$.i18n.prop("config_power_act_import")+","+
		$.i18n.prop("config_power_offered")+","+
		$.i18n.prop("config_temperature")+","+
		$.i18n.prop("config_voltage");
	var strMeasurandListStopTxnClock=
		$.i18n.prop("config_curr_import")+","+
		$.i18n.prop("config_curr_offered")+","+
		$.i18n.prop("config_eng_act_import_register")+","+
		$.i18n.prop("config_eng_act_import_interval")+","+
		$.i18n.prop("config_power_offered")+","+
		$.i18n.prop("config_temperature")+","+
		$.i18n.prop("config_voltage");
	var strMeasurandListStopTxn=
		$.i18n.prop("config_curr_import")+","+
		$.i18n.prop("config_curr_offered")+","+
		$.i18n.prop("config_eng_act_import_register")+","+
		$.i18n.prop("config_power_offered")+","+
		$.i18n.prop("config_temperature")+","+
		$.i18n.prop("config_voltage");
		
    $("#reservation_supported option[value='0']").text($.i18n.prop("config_no"));
    $("#reservation_supported option[value='1']").text($.i18n.prop("config_yes"));

	$("#resume_charging option[value='0']").text($.i18n.prop("config_off"));
	$("#resume_charging option[value='1']").text($.i18n.prop("config_on"));

	$("#rfid_enable option[value='0']").text($.i18n.prop("config_off"));
	$("#rfid_enable option[value='1']").text($.i18n.prop("config_on"));

	$("#ventilation_area option[value='0']").text($.i18n.prop("config_no"));
	$("#ventilation_area option[value='1']").text($.i18n.prop("config_yes"));

	$("#skip_heartbeat option[value='0']").text($.i18n.prop("config_no"));
	$("#skip_heartbeat option[value='1']").text($.i18n.prop("config_yes"));
	
	// Remote Control Settings
	$(".group_remote_control_settings").text($.i18n.prop("group_remote_control_settings"));
	
	//$("#remote_control_type option[value='1']").text($.i18n.prop("config_remote_all"));
	$("#remote_control_type option[value='2']").text($.i18n.prop("config_remote_app"));
	$("#remote_control_type option[value='3']").text($.i18n.prop("config_remote_ocpp"));
	
	// OCPP Settings
    $(".group_service_settings").text($.i18n.prop("group_service_settings"));
    $(".group_ocpp16_settings").text($.i18n.prop("group_ocpp16_settings"));
    
	for(var i = 0; i < ocpp_labels.length; i++){
		$("#tab_ocpp label").eq(i).text(ocpp_labels[i] + ":");
	}
	
	$("#msg_translayer option[value='1']").text($.i18n.prop("config_ws"));
	$("#msg_translayer option[value='2']").text($.i18n.prop("config_wss"));
	
	$("#custom_display_costandprice option[value='1']").text($.i18n.prop("config_false"));
	$("#custom_display_costandprice option[value='2']").text($.i18n.prop("config_true"));

	$("#notification_after_softreset option[value='0']").text($.i18n.prop("config_no"));
	$("#notification_after_softreset option[value='1']").text($.i18n.prop("config_yes"));

	$("#ocpp16_9101 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9101 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9102 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9102 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9103 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9103 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9110 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9110 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9111 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9111 option[value='1']").text($.i18n.prop("config_yes"));
	addComboboxList("#ocpp16_9113", strMeasurandListSampleClock);
	addComboboxList("#ocpp16_9115", strMeasurandListSample);
	addComboboxList("#ocpp16_9125", strMeasurandListStopTxnClock);
	addComboboxList("#ocpp16_9127", strMeasurandListStopTxn);
	$("#ocpp16_9121 option[value='0']").text($.i18n.prop("config_na"));
	$("#ocpp16_9121 option[value='1']").text($.i18n.prop("config_unknown"));
	$("#ocpp16_9121 option[value='2']").text($.i18n.prop("config_rst"));
	$("#ocpp16_9121 option[value='3']").text($.i18n.prop("config_rts"));
	$("#ocpp16_9121 option[value='4']").text($.i18n.prop("config_srt"));
	$("#ocpp16_9121 option[value='5']").text($.i18n.prop("config_str"));
	$("#ocpp16_9121 option[value='6']").text($.i18n.prop("config_trs"));
	$("#ocpp16_9121 option[value='7']").text($.i18n.prop("config_tsr"));
	$("#ocpp16_9123 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9123 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9124 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9124 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9133 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9133 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9201 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9201 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9301 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9301 option[value='1']").text($.i18n.prop("config_yes"));
	$("#ocpp16_9404 option[value='0']").text($.i18n.prop("config_no"));
	$("#ocpp16_9404 option[value='1']").text($.i18n.prop("config_yes"));
	
	
	//IP Settings
	$(".group_active_device").text($.i18n.prop("group_active_device"));
	$(".group_ethernet_settings").text($.i18n.prop("group_ethernet_settings"));
	
	$(".group_wifi_settings").text($.i18n.prop("group_wifi_settings"));
	$(".group_cellular_settings").text($.i18n.prop("group_cellular_settings"));
	$(".group_llm_settings").text($.i18n.prop("group_llm_settings"));

	for(var i = 0; i < ips_labels.length; i++){
		$("#tab_ips label").eq(i).text(ips_labels[i] + ":");
	}

	$("#dev_mode option[value='1']").text($.i18n.prop("config_devmode_direct"));
	$("#dev_mode option[value='2']").text($.i18n.prop("config_devmode_gateway"));
	$("#dev_mode option[value='3']").text($.i18n.prop("config_devmode_client"));

	$("#use_external_gw option[value='0']").text($.i18n.prop("config_no"));
	$("#use_external_gw option[value='1']").text($.i18n.prop("config_yes"));
	
	$("#hide_ap_ssid option[value='0']").text($.i18n.prop("config_off"));
	$("#hide_ap_ssid option[value='1']").text($.i18n.prop("config_on"));
	
	$("#connectivity option[value='0']").text($.i18n.prop("config_none"));
	$("#connectivity option[value='1']").text($.i18n.prop("config_auto"));
	/* eth_off
	$("#connectivity option[value='2']").text($.i18n.prop("config_ethernet"));
	*/
	$("#connectivity option[value='3']").text($.i18n.prop("config_wifi"));
	$("#connectivity option[value='4']").text($.i18n.prop("config_cellular"));

	$("#led_brightness option[value='1']").text($.i18n.prop("config_20"));
	$("#led_brightness option[value='2']").text($.i18n.prop("config_40"));
	$("#led_brightness option[value='3']").text($.i18n.prop("config_60"));
	$("#led_brightness option[value='4']").text($.i18n.prop("config_80"));
	$("#led_brightness option[value='5']").text($.i18n.prop("config_100"));

    $("#active_device").val($.i18n.prop("config_active_none"));
    $("#active_device").disable();

    $("#link_mode option[value='1']").text($.i18n.prop("config_dhcp"));
	$("#link_mode option[value='2']").text($.i18n.prop("config_staticip"));


	$("#wifi_security option[value='0']").text($.i18n.prop("config_ws_none"));
	$("#wifi_security option[value='1']").text($.i18n.prop("config_ws_wep"));
	$("#wifi_security option[value='2']").text($.i18n.prop("config_ws_wpapsk"));
	$("#wifi_security option[value='3']").text($.i18n.prop("config_ws_wpa2psk"));
	$("#wifi_security option[value='4']").text($.i18n.prop("config_ws_wpapskwpa2psk"));
    $("#wifi_security option[value='5']").text($.i18n.prop("config_ws_auto"));

	$("#wifi_station_only option[value='0']").text($.i18n.prop("config_ws_off"));
	$("#wifi_station_only option[value='1']").text($.i18n.prop("config_ws_on"));

    $("#llm_mode option[value='0']").text($.i18n.prop("config_disable"));
	$("#llm_mode option[value='1']").text($.i18n.prop("config_enable"));

	$("#llm_policy option[value='1']").text($.i18n.prop("config_policy_ud"));
	$("#llm_policy option[value='2']").text($.i18n.prop("config_policy_fifs"));
	
	$("#cellular_apntype option[value='0']").text($.i18n.prop("config_pdp_ip"));
	$("#cellular_apntype option[value='1']").text($.i18n.prop("config_pdp_ipv4v6"));

	$("#cellular_port_forwarding option[value='0']").text($.i18n.prop("config_disable"));
	$("#cellular_port_forwarding option[value='1']").text($.i18n.prop("config_enable"));

	//buttons
	$(".iconbutn").find("span").text($.i18n.prop("butn_apply"));
    $(".scanbutn").find("span").text($.i18n.prop("butn_scan"));
}

function initEvent() {
	$("input[about='nochange']").disable();
	$("select[about='nochange']").disable();
	
	$(".iconbutn:has(.warningicon):eq(0)").click(function(){
		request("warning_set");
	});

	$(".iconbutn:has(.generalicon):eq(0)").click(function(){
		request("general_set");
	});
	
	$(".iconbutn:has(.controlicon):eq(0)").click(function(){
		request("control_set");
	});
	
	$(".iconbutn:has(.serviceicon):eq(0)").click(function(){
		request("service_set");
	});
	
	$(".iconbutn:has(.ocppicon):eq(0)").click(function(){
		request("ocpp_set");
	});

	$("#tab_ips .iconbutn").click(function() {
		request("ip_set");
    }); 

	$("#tab_ips .scanbutn").click(function() {
		request("ssid_scan");
    }); 

    $("#dev_mode").change(OnDeviceModeChanged);
    $("#connectivity").change(changeFieldState);
    $("#link_mode").change(checkDHCP);
    $("#wifi_security").change(checkSecurity);
    $("#use_external_gw").change(OnExternalGWChanged);
    $("#llm_mode").change(OnLLMModeChanged);
	
	//============================== Set Validation =======================
	$("#connector_num").each(function(){
		$(this).textValidation({
			regex: /^\d*$/,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_not_numbers")
		});
	});

	$("input[id*='_interval']").each(function(){
		$(this).textValidation({
			regex: /^\d*$/,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_not_numbers")
		});
	});

	$("input[id*='_retries']").each(function(){
		$(this).textValidation({
			regex: /^[+-]?[0-9]*$/,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_not_numbers")
		});
	});

	$("#clpickup_delay").each(function(){
		$(this).textValidation({
			regex: /^\d*$/,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_not_numbers")
		});
	});

	$("input[id*='_timeout']").each(function(){
		$(this).textValidation({
			regex: /^\d*$/,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_not_numbers")
		});
	});

	$("input[id*='temperature_']").each(function(){
		$(this).textValidation({
			regex: /^[+-]?[0-9]*$/,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_not_numbers")
		});
	});

	$("input[id*='voltage_']").each(function(){
		$(this).textValidation({
			regex: /^\d*$/,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_not_numbers")
		});
	});
	
	$("#ip").each(function(){
		$(this).textValidation({
			regex: ip_regex,
	        canBeNull: false,
			nullMsg: $.i18n.prop("message_null"),
	        errorMsg: $.i18n.prop("error_format")
		});
	});
	
	$("#mask").each(function(){
		$(this).textValidation({
			regex: ip_regex,
	        canBeNull: false,
			nullMsg: $.i18n.prop("message_null"),
	        errorMsg: $.i18n.prop("error_format")
		});
	});
	
	$("#default_gateway").each(function(){
		$(this).textValidation({
			regex: ip_regex,
	        canBeNull: false,
			nullMsg: $.i18n.prop("message_null"),
	        errorMsg: $.i18n.prop("error_format")
		});
	});

	$("input[id*=dns]").each(function(){
		$(this).textValidation({
			regex: ip_regex,
	        canBeNull: true,
	        errorMsg: $.i18n.prop("error_format")
		});
	});
	
	$("input[id*=dialnum]").each(function(){
		$(this).textValidation({
	        canBeNull: false,
			nullMsg: $.i18n.prop("message_null"),
	        errorMsg: $.i18n.prop("error_format")
		});
	});
}

function changeFieldState(){
	$("input[about='wifi']").enable();
    $("#wifi_ssid").combobox("enable");
    $("#wifi_ssid_scan").enable();
	$("#wifi_security").enable();
	$("#wifi_station_only").enable();
	if($("#connectivity").val() == CONNECTIVITY.NONE){
		$("#link_mode").disable();
		checkDHCP();
		$("input[about='wifi']").disable();
        $("#wifi_ssid").combobox("disable");
        $("#wifi_ssid_scan").disable();
		$("#wifi_security").disable();
		$("#wifi_station_only").disable();
		$("input[about='cellular']").disable();
		$("select[about='cellular']").disable();
	}else if($("#connectivity").val() == CONNECTIVITY.ETHERNET){
		$("#link_mode").enable();
		checkDHCP();
		$("input[about='wifi']").disable();
        $("#wifi_ssid").combobox("disable");
        $("#wifi_ssid_scan").disable();
		$("#wifi_security").disable();
		$("#wifi_station_only").disable();
		$("input[about='cellular']").disable();
		$("select[about='cellular']").disable();
	}else if($("#connectivity").val() == CONNECTIVITY.WIFI){
		$("#link_mode").disable();
		checkDHCP();
		$("input[about='dhcp']").disable();
		if($("#dev_mode").val() != DEVICEMODE.DIRECT && $("#use_external_gw").val() == 0)
		{
			$("input[about='wifi']").disable();
	        $("#wifi_ssid").combobox("disable");
	        $("#wifi_ssid_scan").disable();
			$("#wifi_security").disable();
			$("#wifi_password").disable();
		    $("#wifi_station_only").disable();
		}
		else
		{
			$("input[about='wifi']").enable();
	        $("#wifi_ssid").combobox("enable");
	        $("#wifi_ssid_scan").enable();
			$("#wifi_security").enable();
		    $("#wifi_station_only").enable();
			checkSecurity();
		}
		$("input[about='cellular']").disable();
		$("select[about='cellular']").disable();
	}else if($("#connectivity").val() == CONNECTIVITY.CELLULAR){
		$("#link_mode").disable();
		checkDHCP();
		$("input[about='dhcp']").disable();
		$("input[about='wifi']").disable();
        $("#wifi_ssid").combobox("disable");
        $("#wifi_ssid_scan").disable();
		$("#wifi_security").disable();
		$("#wifi_station_only").disable();
		$("input[about='cellular']").enable();
		$("select[about='cellular']").enable();
	}else{
		$("#link_mode").enable();
		checkDHCP();
		$("input[about='wifi']").enable();
        $("#wifi_ssid").combobox("enable");
        $("#wifi_ssid_scan").enable();
		$("#wifi_security").enable();
		$("#wifi_station_only").enable();
        checkSecurity();
		$("input[about='cellular']").enable();
		$("select[about='cellular']").enable();
	}
	
	$("input[type='text']").trigger("textchange");
}

function checkDHCP(){
	if($("#connectivity").val() == CONNECTIVITY.AUTO ||
	   $("#connectivity").val() == CONNECTIVITY.ETHERNET)
	{
		if($("#link_mode").val() == MODE.DHCP)
			$("input[about='dhcp']").not("input[id*=_dns]").disable();
		else
			$("input[about='dhcp']").not("input[id*=_dns]").enable();
		
		$("input[id*=_dns]").enable();
		$("input[about='dhcp']").trigger("textchange");
	}
	else
	{
		$("input[about='dhcp']").disable();
		$("input[id*=_dns]").disable();
	}
}

function checkSecurity() {
    if(($("#wifi_security").val() == WIFISECURITY.NONE)) {
        $("#wifi_password").disable();
    }else{
        $("#wifi_password").enable();
    }
}

function OnDeviceModeChanged(){
	if($("#dev_mode").val() == DEVICEMODE.DIRECT){
		$("#llm_mode").val(LLMMODE.DISABLE);
		OnLLMModeChanged();
		OnExternalGWChanged();

		$("input[id='master_lanip']").disable();
		$("input[id='master_lanport']").disable();
		$("input[id='maxdev_number']").disable();
		$("input[id='master_sn']").disable();

        if (g_model_type == "IC")
		    $("#connectivity").enable();
        else {
            $("#connectivity").val(CONNECTIVITY.WIFI);
		    $("#connectivity").disable();
        }
        if (g_model_type != "IC") {
            $("#use_external_gw").val("1");
		    $("#use_external_gw").disable();
        } else {
		    $("#use_external_gw").enable();
        }
		$("#llm_mode").disable();

	}else if($("#dev_mode").val() == DEVICEMODE.GATEWAY){
		if (g_dev_mode)
			$("#llm_mode").val(LLMMODE.ENABLE);
		OnLLMModeChanged();

        if (g_model_type == "IC")
		    $("#connectivity").val(CONNECTIVITY.CELLULAR);
        else {
		    $("#connectivity").val(CONNECTIVITY.WIFI);
		    $("#link_mode").val(MODE.DHCP);
		}
        OnExternalGWChanged();

		$("input[id='master_lanip']").disable();
		$("input[id='master_lanport']").disable();
		$("input[id='maxdev_number']").disable();
		$("input[id='master_sn']").disable();
		$("#connectivity").disable();
		$("#link_mode").disable();

        if (g_model_type != "IC") {
            $("#use_external_gw").val("1");
		    $("#use_external_gw").disable();
        } else {
		    $("#use_external_gw").enable();
        }
		$("#llm_mode").enable();
	}else{ // DEVICEMODE.CLIENT
		if (g_dev_mode)
			$("#llm_mode").val(LLMMODE.ENABLE);	
		OnLLMModeChanged();
		$("#connectivity").val(CONNECTIVITY.WIFI);
		$("#link_mode").val(MODE.DHCP);
		OnExternalGWChanged();
		
		$("input[about='dhcp']").disable();
		$("input[id='master_lanip']").disable();
		$("input[id='master_lanport']").disable();
		$("input[id='maxdev_number']").disable();

        //if use_external_gw is 1, disable master_sn
        if ($("#use_external_gw").val() == 1) {
		    $("input[id='master_sn']").disable();
        } else {
		    $("input[id='master_sn']").enable();
        } 

		$("#connectivity").disable();
		$("#link_mode").disable();
		$("#use_external_gw").enable();
		$("#llm_mode").enable();		
		$("#llm_policy").disable();
		$("input[id='llm_chargers']").disable();
		$("input[id='llm_maxamp_grid']").disable();
		
	}

    changeFieldState();
}

function OnLLMModeChanged(){
	if($("#llm_mode").val() == LLMMODE.ENABLE){
		$("input[about='llm']").enable();
		if($("#dev_mode").val() != DEVICEMODE.CLIENT) {
			$("#llm_policy").enable();
        } else {
		    $("#llm_mode").enable();		
		    $("#llm_policy").disable();
		    $("input[id='llm_chargers']").disable();
		    $("input[id='llm_maxamp_grid']").disable();
        }
	}else{
		$("input[about='llm']").disable();
		$("#llm_policy").disable();
	}
}

function OnExternalGWChanged(){
	if($("#dev_mode").val() == DEVICEMODE.GATEWAY)
	{
		if($("#use_external_gw").val() == 0)
            if (g_model_type == "IC")
			    $("#connectivity").val(CONNECTIVITY.CELLULAR);
            else
			    $("#connectivity").val(CONNECTIVITY.WIFI);
		else
			$("#connectivity").val(CONNECTIVITY.WIFI);
	}

	if($("#dev_mode").val() == DEVICEMODE.CLIENT)
	{
        if ($("#use_external_gw").val() == 0)
            $("input[id='master_sn']").enable();
        else
            $("input[id='master_sn']").disable();
    }
	changeFieldState();
}

function setSCModelUI() {
	if (g_model_type == "SC") {
		$("#reservation_supported").val(0);
		$("#reservation_supported").disable();
		$("#rfid_enable").val(0);
		$("#rfid_enable").disable();
		//$("#dev_mode").disable();
		//$("#master_sn").disable();
		$("#connectivity option[value='1']").attr('disabled', 'disabled').hide();
		$("#connectivity option[value='4']").attr('disabled', 'disabled').hide();
		$("#connectivity").val(CONNECTIVITY.WIFI);
		$("#connectivity").disable();

        if ($("#dev_mode").val() == DEVICEMODE.GATEWAY) {
            $("#use_external_gw").val(1);
            $("#use_external_gw").disable();
        }

        //if use_external_gw is 1, the Gateway Serial Number is useless
        if ($("#use_external_gw").val() == 1) {
		    $("input[id='master_sn']").disable();
        } else {
		    $("input[id='master_sn']").enable();
        } 

	} else if (g_model_type == "SCC") {
		$("#reservation_supported").val(0);
		$("#reservation_supported").disable();
		$("#rfid_enable").val(0);
		$("#rfid_enable").disable();
		$("#dev_mode option[value='2']").attr('disabled', 'disabled').hide();
		$("#master_sn").enable();
		$("#connectivity option[value='1']").attr('disabled', 'disabled').hide();
		$("#connectivity option[value='4']").attr('disabled', 'disabled').hide();

        if ($("#dev_mode").val() == DEVICEMODE.GATEWAY) {
            $("#use_external_gw").val(1);
            $("#use_external_gw").enable();
        }
	} else if (g_model_type == "SCP") {
		//$("#dev_mode option[value='2']").attr('disabled', 'disabled').hide();
		$("#master_sn").enable();
		$("#connectivity option[value='1']").attr('disabled', 'disabled').hide();
		$("#connectivity option[value='4']").attr('disabled', 'disabled').hide();

        if ($("#dev_mode").val() == DEVICEMODE.GATEWAY) {
            $("#use_external_gw").val(1);
            $("#use_external_gw").enable();
        }
	} else {
		return;
	}
}

/**
 * Display all values of configuration page. 
 *  
 * @param data [in] the data returned from the server 
 */
function setForm(data) 
{
    //Basic Information
	$("#cp_vender").val(data.cp_vender);
	$("#cp_model").val(data.cp_model);
	$("#cp_serialnum").val(data.cp_serialnum);
	$("#hard_version").val(data.hard_version);
	$("#firm_version").val(data.firm_version);
	$("#meter_type").val(data.meter_type);
	$("#reader_type").val(data.reader_type);
	$("#dsmr_type").val(data.dsmr_type);
	$("#production_date").val(data.production_date);
    //Charging Connector
	$("#connector_num").val(data.connector_num);
	$("#connector_type").val(data.connector_type);
	$("#connector_maxamp").val(data.connector_maxamp);	
    //Monitoring Criteria
	$("#temperature_low").val(data.temperature_low);
	$("#temperature_high").val(data.temperature_high);
	$("#voltage_low").val(data.voltage_low);
	$("#voltage_high").val(data.voltage_high);
    //Power Settings
    $("#output_powertype").val(data.output_powertype);
	$("#powerphase_connected").val(data.powerphase_connected);
	$("#maxamp_hwsetting").val(data.maxamp_hwsetting);
	$("#maxamp_fwsetting").val(data.maxamp_fwsetting);
	$("#pwm_amp").val(data.pwm_amp);
	$("#real_amp").val(data.real_amp);
	$("#clpickup_delay").val(data.clpickup_delay);
    //Scenario
	$("#plugandcharge_identifier").val(data.plugandcharge_identifier);
	$("#reservation_supported").val(data.reservation_supported);
	$("#memberprice_schemeid").val(data.memberprice_schemeid);
	$("#nonmemberprice_schemeid").val(data.nonmemberprice_schemeid);
	$("#resume_charging").val(data.resume_charging);
	$("#rfid_enable").val(data.rfid_enable);
	$("#ventilation_area").val(data.ventilation_area);
	$("#skip_heartbeat").val(data.skip_heartbeat);
	$("#restart_time").val(data.restart_time);
	$("#restart_counter").val(data.restart_counter);	
	//GPS Information
	$("#latitude").val(data.latitude);
	$("#longitude").val(data.longitude);
	$("#lastboot").val(data.lastboot);
    //OCPP Settings
	$("#cp_identity").val(data.cp_identity);
	$("#protocol_name").val(data.protocol_name);
	$("#server_url").val(data.server_url);
	$("#server_userid").val(data.server_userid);
	$("#server_password").val(data.server_password);
	$("#ftp_userid").val(data.ftp_userid);
	$("#ftp_password").val(data.ftp_password);	
	$("#msg_translayer").val(data.msg_translayer);
	$("#bn_interval").val(data.bn_interval);
	$("#bn_retries").val(data.bn_retries);
	$("#pdu_timeout").val(data.pdu_timeout);
	$("#df_interval").val(data.df_interval);
	$("#df_retries").val(data.df_retries);
	$("#ud_interval").val(data.ud_interval);
	$("#ud_retries").val(data.ud_retries);
	$("#unit_price").val(data.unit_price);
	$("#idle_fee").val(data.idle_fee);
	$("#idle_fee_charging").val(data.idle_fee_charging);
	$("#initiation_fee").val(data.initiation_fee);		
	$("#custom_display_costandprice").val(data.custom_display_costandprice);				
	$("#notification_after_softreset").val(data.notification_after_softreset);				
	$("#ocpp16_9101").val(data.ocpp16_9101);
	$("#ocpp16_9102").val(data.ocpp16_9102);
	$("#ocpp16_9103").val(data.ocpp16_9103);
	$("#ocpp16_9104").val(data.ocpp16_9104);
	$("#ocpp16_9105").val(data.ocpp16_9105);
	$("#ocpp16_9106").val(data.ocpp16_9106);
	$("#ocpp16_9107").val(data.ocpp16_9107);
	$("#ocpp16_9108").val(data.ocpp16_9108);
	$("#ocpp16_9109").val(data.ocpp16_9109);
	$("#ocpp16_9110").val(data.ocpp16_9110);
	$("#ocpp16_9111").val(data.ocpp16_9111);
	$("#ocpp16_9112").val(data.ocpp16_9112);	
	$("#ocpp16_9113").combobox("setValues", data.ocpp16_9113.split(","));
	$("#ocpp16_9114").val(data.ocpp16_9114);
	$("#ocpp16_9115").combobox("setValues", data.ocpp16_9115.split(","));
	$("#ocpp16_9116").val(data.ocpp16_9116);
	$("#ocpp16_9117").val(data.ocpp16_9117);
	$("#ocpp16_9118").val(data.ocpp16_9118);
	$("#ocpp16_9119").val(data.ocpp16_9119);
	$("#ocpp16_9120").val(data.ocpp16_9120);
	$("#ocpp16_9121").val(data.ocpp16_9121);
	$("#ocpp16_9122").val(data.ocpp16_9122);
	$("#ocpp16_9123").val(data.ocpp16_9123);
	$("#ocpp16_9124").val(data.ocpp16_9124);
	$("#ocpp16_9125").combobox("setValues", data.ocpp16_9125.split(","));
	$("#ocpp16_9126").val(data.ocpp16_9126);
	$("#ocpp16_9127").combobox("setValues", data.ocpp16_9127.split(","));
	$("#ocpp16_9128").val(data.ocpp16_9128);
	$("#ocpp16_9129").val(data.ocpp16_9129);
	$("#ocpp16_9130").val(data.ocpp16_9130);
	$("#ocpp16_9131").val(data.ocpp16_9131);
	$("#ocpp16_9132").val(data.ocpp16_9132);
	$("#ocpp16_9133").val(data.ocpp16_9133);
	$("#ocpp16_9134").val(data.ocpp16_9134);
	$("#ocpp16_9201").val(data.ocpp16_9201);
	$("#ocpp16_9202").val(data.ocpp16_9202);
	$("#ocpp16_9203").val(data.ocpp16_9203);
	$("#ocpp16_9301").val(data.ocpp16_9301);
	$("#ocpp16_9401").val(data.ocpp16_9401);
	$("#ocpp16_9402").val(data.ocpp16_9402);
	$("#ocpp16_9403").val(data.ocpp16_9403);
	$("#ocpp16_9404").val(data.ocpp16_9404);
	$("#ocpp16_9405").val(data.ocpp16_9405);
	// Remote Control Settings
	$("#remote_control_type").val(data.remote_control_type);
    //Networking Settings
	$("#dev_mode").val(data.dev_mode);
	$("#master_lanip").val(data.master_lanip);
	$("#master_lanport").val(data.master_lanport);
	$("#maxdev_number").val(data.maxdev_number);
	$("#master_sn").val(data.gateway_serial);
	$("#use_external_gw").val(data.use_external_gw);
	$("#hide_ap_ssid").val(data.hide_ap_ssid);	
	$("#connectivity").val(data.connectivity);
	$("#led_brightness").val(data.led_brightness);
    //Active Device Settings
    if (data.active_device == "1")
        $("#active_device").val($.i18n.prop("config_active_ethernet"));
    else if (data.active_device == "2")
        $("#active_device").val($.i18n.prop("config_active_wifi"));
    else if (data.active_device == "3")
        $("#active_device").val($.i18n.prop("config_active_cellular"));
    else
        $("#active_device").val($.i18n.prop("config_active_none"));

    $("#active_ipaddr").val(data.active_ipaddr);
    $("#active_netmask").val(data.active_netmask);
    $("#active_gateway").val(data.active_gateway);
    $("#active_pridns").val(data.active_pridns);
    $("#active_secdns").val(data.active_secdns);
    //Ethernet Settings
	$("#link_mode").val(data.link_mode);
	$("#ip").val(data.ip);
	$("#mask").val(data.mask);
	$("#default_gateway").val(data.default_gateway);
	$("#primary_dns").val(data.primary_dns);
	$("#secondary_dns").val(data.secondary_dns);
	$("#eth_macaddr").val(data.eth_macaddr);
    //Wi-Fi Settings
    $("#wifi_ssid").combobox("setValue", data.wifi_ssid);
	$("#wifi_security").val(data.wifi_security);
	$("#wifi_password").val(data.wifi_password);
	$("#wifi_bssid").val(data.wifi_bssid);
	$("#wifi_macaddr").val(data.wifi_macaddr);
	$("#wifi_strength").val(data.wifi_strength);
	$("#wifi_station_only").val(data.wifi_station_only);
    //Mobile Settings
	$("#mnc").val(data.mnc);
	$("#iccid").val(data.iccid);
	$("#imsi").val(data.imsi);
	$("#imei").val(data.imei);
	$("#meid").val(data.meid);
	$("#cellular_apn").val(data.cellular_apn);
	$("#cellular_apntype").val(data.cellular_apntype);
	$("#cellular_apnuser").val(data.cellular_apnuser);
	$("#cellular_apnpwd").val(data.cellular_apnpwd);
	$("#cellular_dialnum").val(data.cellular_dialnum);
	$("#cellular_pincode").val(data.cellular_pincode);
	$("#cellular_pridns").val(data.cellular_pridns);
	$("#cellular_secdns").val(data.cellular_secdns);
	$("#cellular_strength").val(data.cellular_strength);
	$("#cellular_wan_ipaddr").val(data.cellular_wan_ipaddr);
	$("#cellular_port_forwarding").val(data.cellular_port_forwarding);
	$("#cellular_port_range").val(data.cellular_port_range);
	$("#cellular_timeout_receive").val(data.cellular_timeout_receive);
    $("#cellular_reconnect").val(data.cellular_reconnect);
    //LLM
	$("#llm_mode").val(data.llm_mode);
	$("#llm_policy").val(data.llm_policy);
	$("#llm_groupid").val(data.llm_groupid);
	$("#llm_chargers").val(data.llm_chargers);
    $("#llm_maxamp_grid").val(data.llm_maxamp_grid);
    $("#llm_fallback").val(data.llm_fallback);
	
	$("#dev_mode").change();
}

function shouldRedirect(){
	//if Connectivity is auto or ethernet
	var connect = $("#connectivity").val();
	if(connect == CONNECTIVITY.AUTO || connect == CONNECTIVITY.ETHERNET){
		if(new RegExp(ip_regex).test($("#ip").val())){
			return true;
		}
	}
	
	return false;
}

function request(action) {
    top.$("#loading").showDialog();
    $.ajax({
        url: selectCGI(action),
        type: "POST",
        cache: false,
        dataType: "json",
        timeout: 120000,
        data: selectjson(action),
        success: function(data, textStatus, XMLHttpRequest) {
            top.$("#loading").hideDialog();

            if (XMLHttpRequest.status == 200) {
                selectfunc(action, data);
            } else {
                error(XMLHttpRequest, textStatus);
            }
        },
        error: function(XMLHttpRequest, textStatus) {
			top.$("#loading").hideDialog();
			
			if(action == "ip_set" && textStatus == "timeout" && shouldRedirect()){
				lightBox({
					title: $.i18n.prop("message_message"),
					width: 200,
					escable: false,
					closable: false,
					buttons: [{
						text: $.i18n.prop("butn_ok"),
						handler: function() {
							top.closeLightBox();
							top.location.href = "http://" + $("#ip").val();
						}
					}]
				}).showMsg($.i18n.prop("config_relogin"));
				
			}else {
				ajaxErrorFunc(XMLHttpRequest, textStatus);
			}
        }
    });
}

/**
 * cgi file to call. 
 *  
 * @param action [in] the type of request 
 */

function selectCGI(action) {
	if (action == "reboot")
    	return "../cgi-bin/Maintain.cgi";

	return "../cgi-bin/Config.cgi";
}

/**
 * Data to be sent to the server. 
 *  
 * @param action [in] the type of request 
 */
function selectjson(action) {
    var req_json = new jsonCreator();
    if (action == "reboot")
   		req_json.addstring("req", "maintainreq");
   	else
   		req_json.addstring("req", "configreq");
    
    switch (action) {
        case "query":
            req_json.addindex("action", REQ_ACTION.QUERY);
            break;

        case "ssid_scan":
            req_json.addindex("action", REQ_ACTION.SSID_SCAN);
            break;
            
        case "control_set":
            req_json.addindex("action", REQ_ACTION.SET);
            req_json.addindex("item", ITEM.REMOTE_CONTROL);
        	req_json.addindex("remote_control_type", $("#remote_control_type").val());
        	
            //Comparing the input string is the same as the original?
            if (($("#remote_control_type").val() != g_remote_control_type)) {
                g_is_reboot = 1; //TRUE
                g_remote_control_type = $("#remote_control_type").val();
            }
        	break;
			
		case "service_set":
            req_json.addindex("action", REQ_ACTION.SET);
            req_json.addindex("item", ITEM.SERVICE);
            
			req_json.addstring("cp_identity", $("#cp_identity").val());
			req_json.addstring("server_url", $("#server_url").val());
			req_json.addstring("server_userid", $("#server_userid").val());
			req_json.addstring("server_password", $("#server_password").val());
			req_json.addstring("ftp_userid", $("#ftp_userid").val());
			req_json.addstring("ftp_password", $("#ftp_password").val());
			req_json.addindex("msg_translayer", $("#msg_translayer").val());
			if (isDigit($("#bn_interval").val()) && atoi($("#bn_interval").val()) >= 0)
				req_json.addindex("bn_interval", toNumber($("#bn_interval").val()));
			if (isNumber($("#bn_retries").val()) && atoi($("#bn_retries").val()) >= -1)
				req_json.addindex("bn_retries", toNumber($("#bn_retries").val()));
			if (isDigit($("#pdu_timeout").val()) && atoi($("#pdu_timeout").val()) >= 0)
				req_json.addindex("pdu_timeout", toNumber($("#pdu_timeout").val()));
			if (isDigit($("#df_interval").val()) && atoi($("#df_interval").val()) >= 0)
				req_json.addindex("df_interval", toNumber($("#df_interval").val()));
			if (isNumber($("#df_retries").val()) && atoi($("#df_retries").val()) >= -1)
				req_json.addindex("df_retries", toNumber($("#df_retries").val()));
			if (isDigit($("#ud_interval").val()) && atoi($("#ud_interval").val()) >= 0)
				req_json.addindex("ud_interval", toNumber($("#ud_interval").val()));
			if (isNumber($("#ud_retries").val()) && atoi($("#ud_retries").val()) >= -1)
				req_json.addindex("ud_retries", toNumber($("#ud_retries").val()));
			
			req_json.addstring("unit_price", $("#unit_price").val());
			req_json.addstring("idle_fee", $("#idle_fee").val());
			req_json.addstring("idle_fee_charging", $("#idle_fee_charging").val());
			req_json.addstring("initiation_fee", $("#initiation_fee").val());			
			req_json.addstring("custom_display_costandprice", $("#custom_display_costandprice").val());
			req_json.addstring("notification_after_softreset", $("#notification_after_softreset").val());

			//Comparing the input string is the same as the original?
            if (($("#cp_identity").val() != g_chargepointid) ||
            	($("#server_url").val() != g_server_url) ||
                ($("#server_userid").val() != g_server_userid) ||
                ($("#server_password").val() != g_server_password)) {
                g_is_reboot = 1; //TRUE
                g_chargepointid = $("#cp_identity").val();
                g_server_url = $("#server_url").val();
                g_server_userid = $("#server_userid").val();
                g_server_password = $("#server_password").val();
            }
			break;
			
		case "ocpp_set":
            req_json.addindex("action", REQ_ACTION.SET);
            req_json.addindex("item", ITEM.OCPP);
            
			req_json.addindex("ocpp16_9101", toNumber($("#ocpp16_9101").val()));
			req_json.addindex("ocpp16_9102", toNumber($("#ocpp16_9102").val()));
			req_json.addindex("ocpp16_9103", toNumber($("#ocpp16_9103").val()));
			if (isDigit($("#ocpp16_9104").val()) && atoi($("#ocpp16_9104").val()) >= 0)
				req_json.addindex("ocpp16_9104", toNumber($("#ocpp16_9104").val()));
			if (isDigit($("#ocpp16_9105").val()) && atoi($("#ocpp16_9105").val()) >= 0)
				req_json.addindex("ocpp16_9105", toNumber($("#ocpp16_9105").val()));
			if (isDigit($("#ocpp16_9106").val()) && atoi($("#ocpp16_9106").val()) >= 0)
				req_json.addindex("ocpp16_9106", toNumber($("#ocpp16_9106").val()));
			if (isDigit($("#ocpp16_9108").val()) && atoi($("#ocpp16_9108").val()) >= 0)
				req_json.addindex("ocpp16_9108", toNumber($("#ocpp16_9108").val()));
			if (isDigit($("#ocpp16_9109").val()) && atoi($("#ocpp16_9109").val()) >= 0)
				req_json.addindex("ocpp16_9109", toNumber($("#ocpp16_9109").val()));
			req_json.addindex("ocpp16_9110", toNumber($("#ocpp16_9110").val()));
			req_json.addindex("ocpp16_9111", toNumber($("#ocpp16_9111").val()));
			if (isDigit($("#ocpp16_9112").val()) && atoi($("#ocpp16_9112").val()) >= 0)
				req_json.addindex("ocpp16_9112", toNumber($("#ocpp16_9112").val()));
			req_json.addstring("ocpp16_9113", $("#ocpp16_9113").combobox("getValues"));
			req_json.addstring("ocpp16_9115", $("#ocpp16_9115").combobox("getValues"));
			if (isDigit($("#ocpp16_9117").val()) && atoi($("#ocpp16_9117").val()) >= 0)
				req_json.addindex("ocpp16_9117", toNumber($("#ocpp16_9117").val()));
			if (isDigit($("#ocpp16_9118").val()) && atoi($("#ocpp16_9118").val()) >= 0)
				req_json.addindex("ocpp16_9118", toNumber($("#ocpp16_9118").val()));
			if (isNumber($("#ocpp16_9120").val()) && atoi($("#ocpp16_9120").val()) >= -1)
				req_json.addindex("ocpp16_9120", toNumber($("#ocpp16_9120").val()));
			req_json.addindex("ocpp16_9121", toNumber($("#ocpp16_9121").val()));
			req_json.addindex("ocpp16_9123", toNumber($("#ocpp16_9123").val()));
			req_json.addindex("ocpp16_9124", toNumber($("#ocpp16_9124").val()));
			req_json.addstring("ocpp16_9125", $("#ocpp16_9125").combobox("getValues"));
			req_json.addstring("ocpp16_9127", $("#ocpp16_9127").combobox("getValues"));
			if (isDigit($("#ocpp16_9131").val()) && atoi($("#ocpp16_9131").val()) >= 0)
				req_json.addindex("ocpp16_9131", toNumber($("#ocpp16_9131").val()));
			if (isDigit($("#ocpp16_9132").val()) && atoi($("#ocpp16_9132").val()) >= 0)
				req_json.addindex("ocpp16_9132", toNumber($("#ocpp16_9132").val()));
			req_json.addindex("ocpp16_9133", toNumber($("#ocpp16_9133").val()));
			if (isDigit($("#ocpp16_9134").val()) && atoi($("#ocpp16_9134").val()) >= 0)
			    req_json.addindex("ocpp16_9134", toNumber($("#ocpp16_9134").val()));
			req_json.addindex("ocpp16_9201", toNumber($("#ocpp16_9201").val()));
            break;
			
        case "ip_set":
            req_json.addindex("action", REQ_ACTION.SET);
            req_json.addindex("item", ITEM.IP);
			
			//Networking Settings
			req_json.addindex("dev_mode", $("#dev_mode").val());
			req_json.addstring("master_lanip", $("#master_lanip").val());
			req_json.addindex("master_lanport", toNumber($("#master_lanport").val()));
			if (isDigit($("#maxdev_number").val()) && atoi($("#maxdev_number").val()) >= 0)
				req_json.addindex("maxdev_number", toNumber($("#maxdev_number").val()));
            req_json.addstring("gateway_serial", $("#master_sn").val());
            req_json.addindex("use_external_gw", $("#use_external_gw").val());
            req_json.addindex("hide_ap_ssid", $("#hide_ap_ssid").val());
			req_json.addindex("connectivity", $("#connectivity").val());
			req_json.addindex("led_brightness", $("#led_brightness").val());
            //Ethernet Settings
			req_json.addindex("link_mode", $("#link_mode").val());
			req_json.addstring("ip", $("#ip").val());
			req_json.addstring("mask", $("#mask").val());
			req_json.addstring("default_gateway", $("#default_gateway").val());
			req_json.addstring("primary_dns", $("#primary_dns").val());
			req_json.addstring("secondary_dns", $("#secondary_dns").val());
            //WiFi Settings
			req_json.addstring("wifi_ssid", $("#wifi_ssid").combobox("getValue"));
			req_json.addstring("wifi_security", $("#wifi_security").val());
			req_json.addstring("wifi_password", $("#wifi_password").val());
			req_json.addstring("wifi_bssid", $("#wifi_bssid").val());
			req_json.addstring("wifi_station_only", $("#wifi_station_only").val());
            //mobile settings
			req_json.addstring("cellular_apn", $("#cellular_apn").val());
			req_json.addstring("cellular_apntype", $("#cellular_apntype").val());
			req_json.addstring("cellular_apnuser", $("#cellular_apnuser").val());
			req_json.addstring("cellular_apnpwd", $("#cellular_apnpwd").val());
			req_json.addstring("cellular_dialnum", $("#cellular_dialnum").val());
			req_json.addstring("cellular_pincode", $("#cellular_pincode").val());
			req_json.addstring("cellular_pridns", $("#cellular_pridns").val());
			req_json.addstring("cellular_secdns", $("#cellular_secdns").val());
			req_json.addstring("cellular_port_forwarding", $("#cellular_port_forwarding").val());
			req_json.addstring("cellular_port_range", $("#cellular_port_range").val());
			req_json.addstring("cellular_timeout_receive", $("#cellular_timeout_receive").val());
            req_json.addstring("cellular_reconnect", $("#cellular_reconnect").val());
			//llm settings
			req_json.addindex("llm_mode", $("#llm_mode").val());
			req_json.addindex("llm_policy", $("#llm_policy").val());
			req_json.addstring("llm_groupid", $("#llm_groupid").val());
			if (isDigit($("#llm_chargers").val()) && atoi($("#llm_chargers").val()) >= 0)
				req_json.addindex("llm_chargers", toNumber($("#llm_chargers").val()));
			req_json.addstring("llm_maxamp_grid", $("#llm_maxamp_grid").val());
			req_json.addstring("llm_fallback", $("#llm_fallback").val());

            //Comparing the input string is the same as the original?
            if (($("#dev_mode").val() != g_dev_mode) || 
                ($("#use_external_gw").val() != g_use_external_gw) ||
                ($("#llm_mode").val() != g_LLMEnable) ||
                ($("#llm_policy").val() != g_LLMPolicy)) {
                g_is_reboot = 1; //TRUE
                g_dev_mode = $("#dev_mode").val();
                g_use_external_gw = $("#use_external_gw").val();
                g_LLMEnable = $("#llm_mode").val();
                g_LLMPolicy = $("#llm_policy").val();
            }
			
			//console.log(JSON.stringify(req_json));
			
            break;

        case "warning_set":
            req_json.addindex("action", REQ_ACTION.SET);
            req_json.addindex("item", ITEM.WARNING);

            //Monitoring Criteria
			if (isNumber($("#temperature_low").val()))
				req_json.addindex("temperature_low", toNumber($("#temperature_low").val()));
			if (isNumber($("#temperature_high").val()))
				req_json.addindex("temperature_high", toNumber($("#temperature_high").val()));
			if (isDigit($("#voltage_low").val()) && atoi($("#voltage_low").val()) >= 0)
				req_json.addindex("voltage_low", toNumber($("#voltage_low").val()));
			if (isDigit($("#voltage_high").val()) && atoi($("#voltage_high").val()) >= 0)
				req_json.addindex("voltage_high", toNumber($("#voltage_high").val()));
            break;

        case "general_set":
            req_json.addindex("action", REQ_ACTION.SET);
            req_json.addindex("item", ITEM.GENERAL);

            //Power Settings
			req_json.addstring("maxamp_fwsetting", $("#maxamp_fwsetting").val());
			if (isDigit($("#clpickup_delay").val()) && atoi($("#clpickup_delay").val()) >= 0)
				req_json.addindex("clpickup_delay", toNumber($("#clpickup_delay").val()));
            //Scenario
			req_json.addstring("plugandcharge_identifier", $("#plugandcharge_identifier").val());
			req_json.addindex("reservation_supported", $("#reservation_supported").val());
			req_json.addindex("resume_charging", $("#resume_charging").val());
			req_json.addindex("rfid_enable", $("#rfid_enable").val());
			req_json.addindex("ventilation_area", $("#ventilation_area").val());
			req_json.addindex("skip_heartbeat", $("#skip_heartbeat").val());
			req_json.addindex("restart_time", $("#restart_time").val());
			req_json.addindex("restart_counter", $("#restart_counter").val());			
            break;
            
        case "reboot":
            req_json.addindex("action", 1);
            break;

        default:
            break;
    }
    
    return req_json.get();
}

/**
 * This function to be called if the request successed. 
 *  
 * @param action [in] the type of request 
 * @param data   [in] the data returned from the server
 */
function selectfunc(action, data) {
    var statuscode = parseInt(data.code);
    
    if (statuscode == 1000) {
        switch (action) {
            case "query":			
                setForm(data);

                //Save these variables templately for reboot prompt message
                g_is_reboot = 0; //FALSE
                g_chargepointid = data.cp_identity;
                g_server_url = data.server_url;
                g_server_userid = data.server_userid;
                g_server_password = data.server_password;
                g_dev_mode = data.dev_mode;
                g_use_external_gw = data.use_external_gw;
                g_LLMEnable = data.llm_mode;
                g_LLMPolicy = data.llm_policy;
                g_remote_control_type = data.remote_control_type;
                
                //Check ModelType and disable some settings for SC3
                checkModelType(data.cp_type);
                setSCModelUI();
                break;

            case "control_set":
            //Check whether popup a reboot prompt message or not
            if (g_is_reboot == 1) { //TRUE
                showConfirmMsg("reboot", $.i18n.prop("message_reboot_prompt"));
                g_is_reboot = 0; //FALSE
            }
            break;

			case "service_set":
            case "ip_set":
                //Check whether popup a reboot prompt message or not
                if (g_is_reboot == 1) { //TRUE
                    showConfirmMsg("reboot", $.i18n.prop("message_reboot_prompt"));
                    g_is_reboot = 0; //FALSE
                }

                //Update Active Device Settings
                if (data.active_device == "1")
                    $("#active_device").val($.i18n.prop("config_active_ethernet"));
                else if (data.active_device == "2")
                    $("#active_device").val($.i18n.prop("config_active_wifi"));
                else if (data.active_device == "3")
                    $("#active_device").val($.i18n.prop("config_active_cellular"));
                else
                    $("#active_device").val($.i18n.prop("config_active_none"));

                $("#active_ipaddr").val(data.active_ipaddr);
                $("#active_netmask").val(data.active_netmask);
                $("#active_gateway").val(data.active_gateway);
                $("#active_pridns").val(data.active_pridns);
                $("#active_secdns").val(data.active_secdns);
                //Update Wifi & Cellular Signal Strength
                $("#wifi_strength").val(data.wifi_strength);
                $("#cellular_strength").val(data.cellular_strength);
                break;

            case "ssid_scan":
                addComboboxList("#wifi_ssid", data.wifi_ssid);
                break;

            case "ocpp_set":
            case "warning_set":
            case "general_set":
	            break;
	        
	        case "reboot":
				showRebootMsg();
	            break;

            default:
                break;
        }
    } else {
		showErrorMsg(statuscode);
    }
}

function showConfirmMsg(cmd, msg){
	lightBox({
		title: $.i18n.prop("message_message"),
		width: 300,
		escable: false,
		closable: false,
		buttons: [{
			text: $.i18n.prop("butn_yes"),
			handler: function() {
				top.closeLightBox();
				setTimeout(function(){
					request(cmd);
				}, 500);
			}
		},{
			text: $.i18n.prop("butn_no"),
			handler: function() {
				top.closeLightBox();
			}
		}]
	}).showMsg(msg);
}

function showRebootMsg()
{
	top.location.href = "../";
}

function addComboboxList(id, data)
{
    var list = [];
    var parseData = data.split(",");
    var i=0;

    for (i=0; i < parseData.length; i++)
    {
        list.push({ "text": parseData[i], "value": parseData[i] });
    }
    $(id).combobox("loadData", list);
}
