(function(a){
    a.event.special.textchange = {
        setup: function(){
            a(this).data("lastValue", this.contentEditable === "true" ? a(this).html() : a(this).val());
            a(this).bind("keyup.textchange", a.event.special.textchange.handler);
            a(this).bind("cut.textchange paste.textchange input.textchange", a.event.special.textchange.delayedHandler)
        },
        teardown: function(){
            a(this).unbind(".textchange")
        },
        handler: function(){
            a.event.special.textchange.triggerIfChanged(a(this))
        },
        delayedHandler: function(){
            var b = a(this);
            setTimeout(function(){
                a.event.special.textchange.triggerIfChanged(b)
            }, 25)
        },
        triggerIfChanged: function(b){
            var c = b[0].contentEditable === "true" ? b.html() : b.val();
            if (c !== b.data("lastValue")) {
                b.trigger("textchange", b.data("lastValue"));
                b.data("lastValue", c)
            }
        }
    };
    a.event.special.hastext = {
        setup: function(){
            a(this).bind("textchange", a.event.special.hastext.handler)
        },
        teardown: function(){
            a(this).unbind("textchange", a.event.special.hastext.handler)
        },
        handler: function(b, c){
            c === "" && c !== a(this).val() && a(this).trigger("hastext")
        }
    };
    a.event.special.notext = {
        setup: function(){
            a(this).bind("textchange", a.event.special.notext.handler)
        },
        teardown: function(){
            a(this).unbind("textchange", a.event.special.notext.handler)
        },
        handler: function(b, c){
            a(this).val() === "" && a(this).val() !== c && a(this).trigger("notext")
        }
    }
})(jQuery);

function showErrorMsg(code){
	var msg = "";
	var butns = null;
	
	var action = "alert";
	var mincode = parseInt(code);
	if(mincode >= 3000 && mincode < 4000) {
		action = "logout";
	}
	msg = $.i18n.prop("result_code_" + mincode);
	switch(action){
		case "logout":
			butns = [{
		        text: $.i18n.prop("butn_ok"),
		        handler: function() {
		            top.closeLightBox();
					//top.request("logout");
					top.location.href = "../";
		        }
		    }];
			break;
			
		case "alert":
		default:
			butns = [{
		        text: $.i18n.prop("butn_ok"),
		        handler: function() {
		            top.closeLightBox();
		        }
		    }];
			break;
	}
	
	lightBox({
		title: $.i18n.prop("message_error"),
		escable: false,
		closable: false,
		buttons: butns
	}).showMsg(msg);
}

function getLang(uri){
	var param = decodeURI(uri);
	var values = param.split("&");
	var obj = {};
	for(var i = 0; i < values.length; i++){
		var value = values[i].split("=");
		obj[value[0]] = value[1];
	}
	
	if(obj.lang) return obj.lang;
	else return 'en-US';
}

function loadI18nBundles(lang){
    $.i18n.properties({
        name: 'Application',
        path: '../i18n/',
        language: lang,
		mode: 'map'
    });
}

function isTopPrivilege(){
	switch(top.privilege){
		case 2:	//Administrator
			return true;
			
		default:
			return false;
	}
}

function showMessage(title, msg){
	var boxWidth = Number(msg.length) * 10;
	if(boxWidth < 50){
		boxWidth = 50;
	}else if(boxWidth > 300){
		boxWidth = 300;
	}
	
	if(!top.isShowLowBattery){
		lightBox({
			title: title,
			width: boxWidth,
			escable: false,
			closable: false,
			buttons: [{
				text: $.i18n.prop("butn_ok"),
				handler: function() {
					top.closeLightBox();
				}
			}]
		}).showMsg(msg);
	}
}

function ajaxErrorFunc(XMLHttpRequest, textStatus){
	switch(textStatus){
		case "timeout":
			showMessage($.i18n.prop("message_error"), $.i18n.prop("message_timeout"));
			break;
			
		case "parsererror":
			showMessage($.i18n.prop("message_error"), $.i18n.prop("message_parseerror"));
			break;
			
		case "error":
		default:
			if(XMLHttpRequest.readyState != 4 || XMLHttpRequest.status == 0){
				showMessage($.i18n.prop("message_error"), $.i18n.prop("message_no_response"));
			}else{
				var msg = $.i18n.prop("message_http_code");
				var status = XMLHttpRequest.status;
				if(status == undefined){
					msg = $.i18n.prop("message_error");
					status = textStatus;
				}
				showMessage($.i18n.prop("message_error"), msg + ": " + status);
			}
			break;
	}
}

function toNumber(value){
	if(isNaN(parseInt(value)) && isNaN(parseFloat(value))){
		return 0;
	}else{
		return value;
	}
}

function atoi(value){
	 return value.charCodeAt();
}

$("input[type=text]").live("blur", function(){
    $(this).removeClass("text_focus");
}).live("focus", function(){
    $(this).addClass("text_focus");
});

$.fn.enable = function(){
	$.each(this,function(){
		$(this).attr("disabled", false);
		if($(this).is("input[type=text]")){
			$(this).removeClass("text_disabled");
		}
	});
}

$.fn.disable = function(){
	$.each(this,function(){
		$(this).attr("disabled", true);
		if($(this).is("input[type=text]")){
			$(this).addClass("text_disabled");
		}
	});
}

function isNumber(val){
    return /^-?((\d+\.?(\d+)?)|(\.\d+))$/.test(val);
}

function isDigit(value) {
	var patrn = /^[0-9]*$/;
	if (patrn.exec(value) == null || value == "") {
		return false;
	}else {
		return true;
	}
}

//json functions
function jsonCreator(){
    this.json = "null";
    this.addstring = addstring;
    this.addindex = addindex;
    this.addstringarray = addstringarray;
    this.addindexarray = addindexarray;
    this.getarray = getarray;
    this.get = get;
    
    function addstring(key, value){
        this.key = key;
        this.value = value;
        if (this.json == "null") 
            this.json = "\"" + key + "\":\"" + value + "\"";
        else 
            this.json += ",\"" + key + "\":\"" + value + "\"";
    }
    
    function addindex(key, value){
        this.key = key;
        this.value = value;
        if (this.json == "null") 
            this.json = "\"" + key + "\":" + value;
        else 
            this.json += ",\"" + key + "\":" + value;
    }
    
    function addstringarray(value){
        this.value = value;
        if (this.json == "null") 
            this.json = "\"" + value + "\"";
        else 
            this.json += ",\"" + value + "\"";
    }
    
    function addindexarray(value){
        this.value = value;
        if (this.json == "null") 
            this.json = value;
        else 
            this.json += "," + value;
    }
    
    function getarray(){
        if (this.json == "null") 
            this.json = "";
			
        var jsonstore = "[" + this.json + "]";
        return jsonstore;
    }
    function get(){
        if (this.json == "null") 
            this.json = "";
			
        var jsonstore = "{" + this.json + "}";
        return jsonstore;
    }
};
//end json functions
var JSON;if(!JSON){JSON={}}(function(){function f(n){return n<10?"0"+n:n}if(typeof Date.prototype.toJSON!=="function"){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf()}}var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==="string"?c:"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+string+'"'}function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==="object"&&typeof value.toJSON==="function"){value=value.toJSON(key)}if(typeof rep==="function"){value=rep.call(holder,key,value)}switch(typeof value){case"string":return quote(value);case"number":return isFinite(value)?String(value):"null";case"boolean":case"null":return String(value);case"object":if(!value){return"null"}gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==="[object Array]"){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||"null"}v=partial.length===0?"[]":gap?"[\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"]":"["+partial.join(",")+"]";gap=mind;return v}if(rep&&typeof rep==="object"){length=rep.length;for(i=0;i<length;i+=1){if(typeof rep[i]==="string"){k=rep[i];v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}else{for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?": ":":")+v)}}}}v=partial.length===0?"{}":gap?"{\n"+gap+partial.join(",\n"+gap)+"\n"+mind+"}":"{"+partial.join(",")+"}";gap=mind;return v}}if(typeof JSON.stringify!=="function"){JSON.stringify=function(value,replacer,space){var i;gap="";indent="";if(typeof space==="number"){for(i=0;i<space;i+=1){indent+=" "}}else{if(typeof space==="string"){indent=space}}rep=replacer;if(replacer&&typeof replacer!=="function"&&(typeof replacer!=="object"||typeof replacer.length!=="number")){throw new Error("JSON.stringify")}return str("",{"":value})}}if(typeof JSON.parse!=="function"){JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==="object"){for(k in value){if(Object.prototype.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v}else{delete value[k]}}}}return reviver.call(holder,key,value)}text=String(text);cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return"\\u"+("0000"+a.charCodeAt(0).toString(16)).slice(-4)})}if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,""))){j=eval("("+text+")");return typeof reviver==="function"?walk({"":j},""):j}throw new SyntaxError("JSON.parse")}}}());

function isJSON(str){
	try {
	    JSON.parse(str);
	} catch (e) {
	    return false;
	}
	return true;
}
