#!/bin/sh
#--------
# The max. length of the serial number is limited to 25 characters.
# It's the same definiton of the master_sn in web portal

n=${#1}
if [ $n -gt 25 ]; then #same define as wep prtal master_sn
    echo "exceed 25 characters limitation"
    echo "NG"
    exit
fi

sqlite3 /mnt/config/ocpp/database/ocpp16-property.sqlite3 "update static set value='$1' where key='ChargePointSerialNumber'" 2> /dev/null

sqlite3 /mnt/config/ocpp/database/ocpp16-property.sqlite3 "update configuration set value='$1' where key='ChargePointId'" 2> /dev/null

HOSTNAME="${1//-}"
HOSTNAME="${HOSTNAME:5}"
HOSTNAME="IC3-"$HOSTNAME
fw_setenv hostname $HOSTNAME

SERIAL="${1//-}"
STATIONID=$(printf $SERIAL | tail -c 3 2> /dev/null)
sqlite3 /mnt/config/ocpp/database/ocpp16-property.sqlite3 "update configuration set value='$SERIAL' where key='StationId'" 2> /dev/null

echo "OK"
