#!/bin/sh

#  Sample ID:	model name
# IC3  		IC3-32A

MODELNAME=$1
MODELTYPE=$2

check_model_type() {
    mt=`fw_printenv modeltype`
    if [ "$mt" != "modeltype=$MODELTYPE" ]; then
        echo "Error: set modeltype failed"
        echo "NG"
        exit;
    fi
}

sqlite3 /mnt/config/ocpp/database/ocpp16-property.sqlite3 "update static set value='$MODELNAME' where key='ChargePointModel'"

#echo "MODELTYPE = $MODELTYPE"
if [ "$MODELTYPE" != "" ]; then
    if [ "$MODELTYPE" == "IC3" ] || [ "$MODELTYPE" == "SC3" ] || [ "$MODELTYPE" == "SC3_PLUS" ] || [ "$MODELTYPE" == "SC3_CLIENT" ]; then
        fw_setenv modeltype $MODELTYPE
        check_model_type
    else
        echo "Error: invalid MODELTYPE"
        echo "NG"
        exit;
    fi
fi

echo "OK"