#!/bin/sh
#--------
# The max. length of the serial number is limited to 25 characters by /usr/sbin/ft/setsn.sh
# Due to prefix "IC3-", the max. length of SSID is 28 characters.
#
SERIAL=$(sqlite3 /mnt/config/ocpp/database/ocpp16-property.sqlite3 "select value from static where key='ChargePointSerialNumber';" 2> /dev/null)

if [ -z "$SERIAL" ]; then
    SERIAL=NoSerialNumber
else
    SERIAL="${SERIAL//-}"
    SERIAL="${SERIAL:5}"
    n=${#SERIAL}
    if [ $n -gt 28 ]; then #if length exceeds, the last 28 characters will be used.
        SERIAL=$(printf $SERIAL | tail -c 28 2> /dev/null)
    fi
fi

SSID="IC3-"$SERIAL
AP_PASSWORD=$SERIAL"@IC3"

uci set wireless.ap.ssid="$SSID"
uci set wireless.ap.key="$AP_PASSWORD"
uci set wireless.ap.encryption="psk2"
uci set wireless.ap.hidden="0"
uci commit

