#!/bin/sh


IC3_SC_EXTERNALEXEC_LABEL=IC3_RUNTEST
IC3_SC_EXTERNALEXEC_PATH=/mnt/rootfs
IC3_SC_EXTERNALEXEC_FILE=nbtest/doNBTest.sh

IC3_SC_PARTITION_LABEL=IC3_CONFIG
IC3_SC_PARTITION_UUID=
IC3_SC_PARTITION_TARGET=/mnt/config
MMCGB=0
CHECK_AGAIN=0


mmc_exist()
{
  if [ -b /dev/mmcblk0 ]; then
    return 0
  fi

  return 1
}

mmc_externalexectype()
{
  CURR_TYPE=`block info /dev/mmcblk0p1 | sed 's/^.*TYPE=\"//g' | sed 's/\".*$//g'`

  if [ "$CURR_TYPE" == "vfat" ]; then
    return 0
  fi

  return 1
}

mmc_externalexeclabel()
{
  CURR_LABEL=`block info /dev/mmcblk0p1 | grep LABEL | sed 's/^.*LABEL=\"//g' | sed 's/\".*$//g'`

  if [ "$CURR_LABEL" == "$IC3_SC_EXTERNALEXEC_LABEL" ]; then
    return 0
  fi

  return 1
}

mmc_externalexec_check()
{
  if ! mmc_externalexectype; then
#    error_handler "Wrong External Type"
    return 1
  fi

  if ! mmc_externalexeclabel; then
#    error_handler "Wrong External Label"
    return 1
  fi

  mount /dev/mmcblk0p1 $IC3_SC_EXTERNALEXEC_PATH
  sleep 1

  if [ -f $IC3_SC_EXTERNALEXEC_PATH/$IC3_SC_EXTERNALEXEC_FILE ]; then
    chmod a+x $IC3_SC_EXTERNALEXEC_PATH/$IC3_SC_EXTERNALEXEC_FILE
    $IC3_SC_EXTERNALEXEC_PATH/$IC3_SC_EXTERNALEXEC_FILE
  else
    error_handler Cannot find external executable file
  fi

  return 0
}

mmc_checksize()
{
  MMCGB=`fdisk -l /dev/mmcblk0 | grep GiB | awk '{ print $3 }'`

  RET=`awk 'BEGIN{ print ("'$MMCGB'" < 7.0) }'`

  return $RET
}

mmc_partitionnumber()
{
  RET=`ls -l /dev/mmcblk0p* | wc | awk '{ print $1 }'`

  if [ $RET == 1 ]; then
    return 0
  fi

  return 1
}

mmc_partitiontype()
{
  CURR_TYPE=`block info /dev/mmcblk0p1 | sed 's/^.*TYPE=\"//g' | sed 's/\".*$//g'`

  if [ "$CURR_TYPE" == "ext4" ]; then
    return 0
  fi

  return 1
}

mmc_partitionlabel()
{
  CURR_LABEL=`block info /dev/mmcblk0p1 | grep LABEL | sed 's/^.*LABEL=\"//g' | sed 's/\".*$//g'`

  if [ "$CURR_LABEL" == "$IC3_SC_PARTITION_LABEL" ]; then
    return 0
  fi

  return 1
}

mmc_partition_check()
{
  if ! mmc_partitionnumber; then
    error_handler "Too many partition"
    return 1
  fi

  if ! mmc_partitiontype; then
    error_handler "Wrong Partition Type"
    return 1
  fi

  if ! mmc_partitionlabel; then
    error_handler "Wrong Partition Label"
    return 1
  fi

  return 0
}

check_automount()
{
  CONFIG_UUID=`uci get fstab.@mount[0].uuid`
  CONFIG_ENABLED=`uci get fstab.@mount[0].enabled`
  CONFIG_TARGET=`uci get fstab.@mount[0].target`
  CURR_UUID=`block info /dev/mmcblk0p1 | sed 's/^.*UUID=\"//g' | sed 's/\".*$//g'`

  if [ "$CONFIG_UUID" != "$CURR_UUID" ]; then
    return 1
  fi

  if [ "$CONFIG_TARGER" != "$IC3_SC_PARTITION_TARGET" ]; then
    return 1
  fi

  if [ "$CONFIG_ENABLED" == 0 ]; then
    return 1
  fi

  return 0
}


format_sdcard()
{
  (
  echo g # create a new empty GPT partition table
  echo n # Add a new partition
  echo 1 # Partition number
  echo   # First sector (Accept default: 2048)
  echo   # Last sector (Accept default: varies)
  echo w # Write changes
  ) | fdisk /dev/mmcblk0

  sleep 1

  mkfs.ext4 /dev/mmcblk0p1 -L $IC3_SC_PARTITION_LABEL -F
}

do_automount()
{
  setup_automount
  mount_partition
}

setup_automount()
{
  block detect > /etc/config/fstab

  uci set fstab.@mount[0].enabled=1
  uci set fstab.@mount[0].target=$IC3_SC_PARTITION_TARGET
  uci commit
}

mount_partition()
{
  mount /dev/mmcblk0p1 $IC3_SC_PARTITION_TARGET -t ext4
}

error_handler()
{
  echo "$1"

  /usr/bin/oledft "ERROR" "$1"

  rm /dev/shm/i* -f
  /usr/bin/if_common_shm &
  /usr/bin/shminfo evse_fault 1
}


if ! mmc_exist; then
  error_handler "No SD Card"
  exit 0
fi

if mmc_externalexec_check; then
  exit 0
fi

if ! mmc_checksize; then
  error_handler "Small SD: "$MMCGB" GiB"
  exit 0
fi

if ! mmc_partition_check; then
  format_sdcard
  CHECK_AGAIN=1
fi

if [ "$CHECK_AGAIN" == 1 ]; then
  if ! mmc_partition_check; then
    error_handler "Format SD Card fail"
    exit 0
  fi
fi

if ! check_automount; then
  do_automount
fi

/usr/bin/startAP.sh
echo done.

