#!/bin/sh

#================Customized model name modify================

DBFILE_OCPP16="/mnt/config/ocpp/database/ocpp16-property.sqlite3"
GROUP_FILE="/mnt/config/ic/etc/group.conf"
NM_FILE="/mnt/config/ic/etc/NetworkManager.conf"

#Update def. measurand
DEFAULT_METER_VALUES_ALIGNED_DATA="Current.Import,Current.Offered,Energy.Active.Import.Register,Energy.Active.Import.Interval,Power.Active.Import,Power.Offered,Temperature,Voltage"
DEFAULT_METER_VALUES_SAMPLED_DATA="Current.Import,Current.Offered,Energy.Active.Import.Register,Power.Active.Import,Power.Offered,Temperature,Voltage"
DEFAULT_STOP_TXN_ALIGNED_DATA="Current.Import,Current.Offered,Energy.Active.Import.Register,Energy.Active.Import.Interval,Power.Offered,Temperature,Voltage"
DEFAULT_STOP_TXN_SAMPLED_DATA="Current.Import,Current.Offered,Energy.Active.Import.Register,Power.Offered,Temperature,Voltage"
sqlite3 $DBFILE_OCPP16 "update configuration set value='$DEFAULT_METER_VALUES_ALIGNED_DATA' where key='MeterValuesAlignedData'"
sqlite3 $DBFILE_OCPP16 "update configuration set value='8' where key='MeterValuesAlignedDataMaxLength'"
sqlite3 $DBFILE_OCPP16 "update configuration set value='$DEFAULT_METER_VALUES_SAMPLED_DATA' where key='MeterValuesSampledData'"
sqlite3 $DBFILE_OCPP16 "update configuration set value='7' where key='MeterValuesSampledDataMaxLength'"
sqlite3 $DBFILE_OCPP16 "update configuration set value='$DEFAULT_STOP_TXN_ALIGNED_DATA' where key='StopTxnAlignedData'"
sqlite3 $DBFILE_OCPP16 "update configuration set value='7' where key='StopTxnAlignedDataMaxLength'"
sqlite3 $DBFILE_OCPP16 "update configuration set value='$DEFAULT_STOP_TXN_SAMPLED_DATA' where key='StopTxnSampledData'"
sqlite3 $DBFILE_OCPP16 "update configuration set value='6' where key='StopTxnSampledDataMaxLength'"

#Write customized vender
VENDERNAME=LITEON
sqlite3 $DBFILE_OCPP16 "update static set value='$VENDERNAME' where key='ChargePointVendor'"
PRODUCTIONDATE=$(sqlite3 $DBFILE_OCPP16 "select value from static where key='ProductionDate';" 2> /dev/null)

#update max. group size
sed -i 's/maxdev_number                  = \"12\"/maxdev_number                  = \"20\"/g' $NM_FILE

./sb_upgrade.sh $PRODUCTIONDATE

if [ -f ./nb_upgrade.sh ]; then
    ./nb_upgrade.sh
    if [ "$?" == "0" ]; then
        echo "nb_upgrade.sh return SUCCESS"
    else
        echo "nb_upgrade.sh return ERROR"
	    exit 1;
    fi
fi

#check PCBA version
echo 2 > /sys/class/gpio/export
echo in > /sys/class/gpio/gpio2/direction
LTE_EG91=`cat /sys/class/gpio/gpio2/value`

if [ "$LTE_EG91" == "1" ]; then
  echo "LTE: EG91 -> no need upgrade"
else
  echo "LTE: ELS61-US/ELS31-US"
  #LTE module firmware upgrade
  if [ -f "./lte/lte-fw-upgrade.sh" ]; then
    echo "LTE firmware upgrade - start"
    ./lte/lte-fw-upgrade.sh
    echo "LTE firmware upgrade - end"
  
  fi
fi



