#!/bin/sh

# 
# Old firmware version, < V1.00.80 may have following issue:
#
#   When upgrading firmware, charger has rare posibility to upgrade fail
#   due to getFileSystemZone() return -1 which means it cannot read out
#   current partition setting.
# 
# An alternative network board firmware upgrade mechanism can fix it.
# if CUR_PART=1, upgrade part0
# if CUR_PART=0, upgrade part1
DEVICE_FILESYSTEM_ZONE_0=/dev/mtdblock6
DEVICE_FILESYSTEM_ZONE_1=/dev/mtdblock7
FIRMWARE_PATH=/mnt/config/ic/firmware
FIRMWARE_NAME=rootfs.tar.bz2
MOUNT_ROOTFS=/mnt/rootfs
UNTAR_PATH=upper

echo "start NB upgrade..."
RETRY=0
while [ $RETRY -le 10 ]; do
    CUR_PART=`fw_printenv | grep 'bootrootfs' | cut -d'=' -f2`
    echo "CUR_PART=$CUR_PART"

    RETRY=$(($RETRY+1))
    if [ "$CUR_PART" == "0" ] || [ "$CUR_PART" == "1" ]; then
        break;
    fi
done

if [ "$CUR_PART" == "0" ] || [ "$CUR_PART" == "1" ]; then
    if [ "$CUR_PART" == "0" ]; then
        DEV_PART=$DEVICE_FILESYSTEM_ZONE_1
        NEWFS=1
    else
        DEV_PART=$DEVICE_FILESYSTEM_ZONE_0
        NEWFS=0
    fi

    RETRY0=0
    while [ $RETRY0 -le 10 ]; do
        echo "CUR_PART=$CUR_PART DEV_PART=$DEV_PART NEWFS=$NEWFS"

        mount -t jffs2 $DEV_PART $MOUNT_ROOTFS
        sleep 2
        if [ ! -d "$MOUNT_ROOTFS/$UNTAR_PATH" ]; then
            echo "ERROR: $MOUNT_ROOTFS/$UNTAR_PATH DOES NOT exists."
    	    RETRY0=$(($RETRY0+1))
        else
    	    tar jxvf $FIRMWARE_PATH/$FIRMWARE_NAME -C $MOUNT_ROOTFS/$UNTAR_PATH

    	    RETRY=0
    	    while [ $RETRY -le 10 ]; do
    	        fw_setenv bootrootfs $NEWFS
    	        NEW_PART=`fw_printenv | grep 'bootrootfs' | cut -d'=' -f2`
    	        echo "NEW_PART=$NEW_PART"

    	        RETRY=$(($RETRY+1))
    	        if [ "$NEW_PART" == "$NEWFS" ]; then
    	            break;
    	        fi
    	    done    
    	    if [ "$NEW_PART" == "$NEWFS" ]; then
    	        echo "NB upgrade successful"
    	        RETVAL=0
                break;
    	    else
    	        echo "ERROR: cannot set bootrootfs, upgrade NB fail"
    	        RETVAL=1
                break;
    	    fi
        fi
    done

    if [ "$RETRY0" -gt "10" ]; then
        echo "ERROR: $MOUNT_ROOTFS/$UNTAR_PATH DOES NOT exists."
    	RETVAL=1
    fi
else
    echo "ERROR: cannot read bootrootfs variable, upgrade NB fail"
    RETVAL=1
fi
echo "end NB upgrade..."

if [ "$RETVAL" == "0" ]; then
    exit 0;
else
    exit 1;
fi
